/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-10-21
 * Description : a kipi plugin to slide images.
 *
 * Copyright (C) 2003-2007 Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// QT includes

#include <tqstring.h>
#include <tqwidget.h>
#include <tqevent.h>
#include <tqstrlist.h>
#include <tqdragobject.h>
#include <tqfileinfo.h>
#include <tqlistbox.h>

// KDE includes

#include <tdelistbox.h>
#include <kurl.h>

// Local includes

#include "listimageitems.h"
#include "listimageitems.moc"

namespace KIPISlideShowPlugin
{

ListImageItems::ListImageItems(TQWidget *parent, const char *name)
              : TDEListBox(parent, name)
{
    setSelectionMode (TQListBox::Extended);
    setAcceptDrops(true);
}

void ListImageItems::dragEnterEvent(TQDragEnterEvent *e)
{
    e->accept(TQUriDrag::canDecode(e));
}

void ListImageItems::dropEvent(TQDropEvent *e)
{
    TQStrList strList;
    KURL::List filesUrl;

    if ( !TQUriDrag::decode(e, strList) ) return;

    TQStrList stringList;
    TQStrListIterator it(strList);
    char *str;

    while ( (str = it.current()) != 0 )
    {
        TQString filePath = TQUriDrag::uriToLocalFile(str);
        TQFileInfo fileInfo(filePath);

        if (fileInfo.isFile() && fileInfo.exists())
        {
            KURL url(fileInfo.filePath());
            filesUrl.append(url);
        }

        ++it;
    }

    if (filesUrl.isEmpty() == false)
        emit addedDropItems(filesUrl);
}

}  // NameSpace KIPISlideShowPlugin
