/***************************************************************************
 *     Copyright (C) 2004 by Sashmit Bhaduri                               *
 *     smt@vfemail.net                                                     *
 *                                                                         *
 *     Licensed under GPL.                                                 *
 ***************************************************************************/

#include <tdeparts/browserextension.h>

//#include <libtdepim/progressmanager.h>

#include "frame.h"

using namespace KlamAV;

Frame::Frame(TQObject * parent, KParts::ReadOnlyPart *p, TQWidget *visWidget, const TQString& tit, bool watchSignals)
   :TQObject(parent, "KlamAVFrame")
{
    m_part=p;
    m_widget=visWidget;
    m_title=tit;
    m_state=Idle;
    m_progress=-1;
    m_progressItem=0;

    if (watchSignals) // e.g, articles tab has no part
    {
        connect(m_part, TQ_SIGNAL(setWindowCaption (const TQString &)), this, TQ_SLOT(setCaption (const TQString &)));
        connect(m_part, TQ_SIGNAL(setStatusBarText (const TQString &)), this, TQ_SLOT(setStatusText (const TQString &)));

        KParts::BrowserExtension *ext=KParts::BrowserExtension::childObject( p );
        if (ext)
            connect( ext, TQ_SIGNAL(loadingProgress(int)), this, TQ_SLOT(setProgress(int)) );

        connect(p, TQ_SIGNAL(started(TDEIO::Job*)), this, TQ_SLOT(setStarted()));
        connect(p, TQ_SIGNAL(completed()), this, TQ_SLOT(setCompleted()));
        connect(p, TQ_SIGNAL(canceled(const TQString &)), this, TQ_SLOT(setCanceled(const TQString&)));
        connect(p, TQ_SIGNAL(completed(bool)), this, TQ_SLOT(setCompleted()));

/*        TDEActionCollection *coll=p->actionCollection();
        if (coll)
        {
            connect( coll, TQ_SIGNAL( actionStatusText( const TQString & ) ),
             this, TQ_SLOT( slotActionStatusText( const TQString & ) ) );
            connect( coll, TQ_SIGNAL( clearStatusText() ),
             this, TQ_SLOT( slotClearStatusText() ) );
        }
*/
    }
}

Frame::~Frame()
{
/*    if(m_progressItem) {
        m_progressItem->setComplete();
    }*/
}

int Frame::state() const
{
    return m_state;
}

KParts::ReadOnlyPart *Frame::part() const
{
    return m_part;
}

TQWidget *Frame::widget() const
{
    return m_widget;
}

void Frame::setTitle(const TQString &s)
{
    m_title=s;
}

void Frame::setCaption(const TQString &s)
{
/*    if(m_progressItem) m_progressItem->setLabel(s);*/
    m_caption=s;
    emit captionChanged(s);
}

void Frame::setStatusText(const TQString &s)
{
    m_statusText=s;
    emit statusText(s);
}

void Frame::setProgress(int a)
{
/*    if(m_progressItem) {
        m_progressItem->setProgress((int)a);
    }*/
    m_progress=a;
    emit loadingProgress(a);
}

void Frame::setState(int a)
{
    m_state=a;
    
    switch (m_state)
    {
        case Frame::Started:
            emit started();
            break;
        case Frame::Canceled:
            emit canceled(TQString::null);
            break;
        case Frame::Idle:
        case Frame::Completed:
        default:
            emit completed();
    }}



const TQString Frame::title() const
{
    return m_title;
}

const TQString Frame::caption() const
{
    return m_caption;
}

const TQString Frame::statusText() const
{
    return m_statusText;
}

void Frame::setStarted()
{
    //if(m_progressId.isNull() || m_progressId.isEmpty()) m_progressId = KPIM::ProgressManager::getUniqueID();
    //m_progressItem = KPIM::ProgressManager::createProgressItem(m_progressId, title(), TQString::null, false);
    //m_progressItem->setStatus(i18n("Loading..."));
    //connect(m_progressItem, TQ_SIGNAL(progressItemCanceled(KPIM::ProgressItem*)), TQ_SLOT(slotAbortFetch()));
    m_state=Started;
    emit started();
}

void Frame::setCanceled(const TQString &s)
{
/*    if(m_progressItem) {
        m_progressItem->setStatus(i18n("Loading canceled"));
        m_progressItem->setComplete();
        m_progressItem = 0;
    }*/
    m_state=Canceled;
    emit canceled(s);
}

void Frame::setCompleted()
{
/*    if(m_progressItem) {
        m_progressItem->setStatus(i18n("Loading completed"));
        m_progressItem->setComplete();
        m_progressItem = 0;
    }*/
    m_state=Completed;
    emit completed();
}

int Frame::progress() const
{
    return m_progress;
}

#include "frame.moc"
