/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#include "klamav.h"
#include "version.h"
#include "klamavconfig.h"
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdeuniqueapplication.h>

static const char *description =
    I18N_NOOP("KlamAV - Virus Protection for TDE");

static const char *version = KLAMAV_VERSION;
//static const char title[] = "KlamAV";

static TDECmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    { "scanthis", I18N_NOOP("Scan this..."), 0 },
    { 0, 0, 0 }
};

int main(int argc, char **argv)
{
    TDEAboutData about(
	"klamav", "KlamAV", KLAMAV_VERSION,
	I18N_NOOP( "KlamAV - Virus Protection for TDE" ),
	TDEAboutData::License_GPL_V2,
	"Copyright (c) 2020, The Trinity Desktop project\nCopyright (c) 2004-2006, Robert Hogan",
	"KlamAV is a front-end for ClamAV."
    );

    about.addAuthor( "Robert Hogan", "Original Author", "robert@roberthogan.net" );

    about.setTranslator(I18N_NOOP2("NAME OF TRANSLATORS","Your names"), I18N_NOOP2("EMAIL OF TRANSLATORS","Your emails"));

    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions(options);
    TDEUniqueApplication app;
    

    // register ourselves as a dcop client
    //app.dcopClient()->registerAs(app.name(), false);

    // see if we are starting with session management
    
    //if (app.isRestored())
    //    RESTORE(Klamav)
    //else
    //{
        // no session.. just start up normally
        TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            new Klamav;
            //widget->show();
        }
        else
        {
            //int i = 0;
            //for (; i < args->count(); i++)
            //{
                new Klamav;
                //widget->show();
                //widget->load(args->url(i));
            //}
        }
        args->clear();
    //}
    return app.exec();
}
