
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2007 Jari-Matti Mäkelä <jmjm@iki.fi>                    *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/***************************************************************************
    This is the "old" code generator that does not support code editing
    in the Modeller but uses significantly less file space because the
    source code is not replicated in the XMI file.
 ***************************************************************************/

#ifndef DWRITER_H
#define DWRITER_H

#include "simplecodegenerator.h"
#include "../umloperationlist.h"
#include "../umlattributelist.h"
#include "../umlassociationlist.h"

class UMLOperation;

/**
  * class DWriter is a code generator for UMLClassifier objects.
  * Create an instance of this class, and feed it a UMLClassifier when
  * calling writeClass and it will generate a d source file for
  * that concept
  */
class DWriter : public SimpleCodeGenerator {
public:

    /**
     * Constructor, initialises a couple of variables
     */
    DWriter();

    /**
     * Destructor, empty
     */
    virtual ~DWriter();

    /**
     * call this method to generate d code for a UMLClassifier
     * @param c the class to generate code for
     */
    virtual void writeClass(UMLClassifier *c);

    /**
     * returns "D"
     */
    virtual Uml::Programming_Language getLanguage();

    /**
     * Overrides method from class CodeGenerator
     */
    TQStringList defaultDatatypes();

private:

    /**
     * Writes the module declaration.
     */
    void writeModuleDecl(UMLClassifier *c, TQTextStream &d);

    /**
     * Writes the module imports.
     */
    void writeModuleImports(UMLClassifier *c, TQTextStream &d);

    /**
     * Writes class's documentation then the class header
     * public abstract class Foo extents {
     */
    void writeClassDecl(UMLClassifier *c, TQTextStream &d);

    /**
     * Writes the comment and class constructor
     */
    void writeConstructor(UMLClassifier *c, TQTextStream &d);

    /**
     * return true if the two operations have the same name and the same parameters
     * @param op1 first operation to be compared
     * @param op2 second operation to be compared
     */
    static bool compareDMethod(UMLOperation *op1, UMLOperation *op2);

    /**
     * return true if the operation is in the list
     * @param umlOp operation to be searched
     * @param opl list of operations
     */
    static bool dMethodInList(UMLOperation *umlOp, UMLOperationList &opl);

    /**
     * get all operations which a given class inherit from all its super interfaces and get all operations
     * which this given class inherit from all its super classes
     * @param c the class for which we are generating code
     * @param yetImplementedOpList the list of yet implemented operations
     * @param toBeImplementedOpList the list of to be implemented operations
     * @param noClassInPath tells if there is a class between the base class and the current interface
     */
    void getSuperImplementedOperations(UMLClassifier *c, UMLOperationList &yetImplementedOpList ,UMLOperationList &toBeImplementedOpList, bool noClassInPath = true);

    /**
     * get all operations which a given class inherit from all its super interfaces and that should be implemented
     * @param c the class for which we are generating code
     * @param opl the list of operations used to append the operations
     */
    void getInterfacesOperationsToBeImplemented(UMLClassifier *c, UMLOperationList &opl);

     /**
     * write all operations for a given class
     * @param c the class for which we are generating code
     * @param j the stream associated with the output file
     */
    void writeOperations(UMLClassifier *c, TQTextStream &j);

    /**
     * write a list of operations for a given class
     * @param list the list of operations you want to write
     * @param j the stream associated with the output file
     */
    void writeOperations(UMLOperationList &list, TQTextStream &j);

    /**
     * write all attributes for a given class
     * @param c the class for which we are generating code
     * @param j the stream associated with the output file
     */
    void writeAttributes(UMLClassifier *c, TQTextStream &j);

    /**
     * Writes the protection modifier line.
     * @param visibility protection modifier
     * @param d text stream
     */
    void writeProtectionMod(Uml::Visibility visibility, TQTextStream &d);
    
    /**
     * Writes attribute declarations with a specific
     * protection modifier.
     * @param prot the protection modifier
     * @param atlist attribute list
     * @param d text stream
     */
    void writeAttributeDecl(Uml::Visibility visibility, UMLAttributeList &atlist, TQTextStream &d);

    /**
     * writes the Attribute declarations
     * @param atpub List of public attributes
     * @param atprot list of protected attributes
     * @param atpriv list of private attributes
     * @param d text stream
     */
    void writeAttributeDecls(UMLAttributeList &atpub, UMLAttributeList &atprot,
                             UMLAttributeList &atpriv, TQTextStream &d );

    /**
     * Searches a list of associations for appropriate ones to write out as attributes
     */
    void writeAssociationDecls(UMLAssociationList associations, Uml::IDType id, TQTextStream &d);

    /**
     * Writes out an association as an attribute using Vector
     */
    void writeAssociationRoleDecl(TQString fieldClassName, TQString roleName, TQString multi,
                                  TQString doc, Uml::Visibility visib, TQTextStream &d);

    /**
     * calls @ref writeSingleAttributeAccessorMethods() on each of the attributes in atpub
     */
    void writeAttributeMethods(UMLAttributeList &atpub, Uml::Visibility visibility, TQTextStream &d);

    /**
     * calls @ref writeAssociationRoleMethod() on each of the associations in the given list
     */
    void writeAssociationMethods(UMLAssociationList associations, UMLClassifier *thisClass,
                                 TQTextStream &d);

    /**
     * calls @ref writeSingleAttributeAccessorMethods() or @ref
     * writeVectorAttributeAccessorMethods() on the assocaition
     * role
     */
    void writeAssociationRoleMethod(TQString fieldClassName, TQString roleName, TQString multi,
                                    TQString description, Uml::Visibility visib, Uml::Changeability_Type change,
                                    TQTextStream &d);

    /**
     * Writes getFoo() and setFoo() accessor methods for the attribute
     */
    void writeSingleAttributeAccessorMethods(TQString fieldClassName, TQString fieldVarName,
            TQString fieldName, TQString description,
            Uml::Visibility visibility, Uml::Changeability_Type change,
            bool isFinal, TQTextStream &d);

    /**
     * Writes addFoo() and removeFoo() accessor methods for the Vector attribute
     */
    void writeVectorAttributeAccessorMethods(TQString fieldClassName, TQString fieldVarName,
            TQString fieldName, TQString description,
            Uml::Visibility visibility, Uml::Changeability_Type change,
            TQTextStream &d);

    /**
     * Writes a // style comment
     */
    void writeComment(const TQString &text, const TQString &indent, TQTextStream &d, bool dDocStyle=false);

    /**
     * Writes a documentation comment
     */
    void writeDocumentation(TQString header, TQString body, TQString end, TQString indent, TQTextStream &d);

    /**
     * Returns the name of the given object (if it exists)
     */
    TQString getUMLObjectName(UMLObject *obj);

    /**
     * Lowers the case of the first letter in the given string
     */
    TQString deCapitaliseFirstLetter(TQString string);

    /**
     * Returns the plural form of a subject.
     */
    TQString pluralize(TQString string);
 
    /**
     * Returns the non-plural form of a subject.
     */
    TQString unPluralize(TQString string);
    
    /**
     * Replaces `string' with `String' and `bool' with `boolean'
     */
    TQString fixTypeName(const TQString& string);

    /**
     * check that initial values of strings have quotes around them
     */
    TQString fixInitialStringDeclValue(TQString value, TQString type);

    /**
     * Write a blank line
     */
    void writeBlankLine(TQTextStream& d);

    /**
     * a little method for converting scope to string value
     */
    TQString scopeToDDecl(Uml::Visibility scope);

    /**
     * A \n, used at the end of each line
     */
    TQString startline;

    /**
     * Whether or not this concept is an interface.
     */
    bool isInterface;

};


#endif // DWRITER_H

