/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#include "msgfmt.h"

#include <tdeapplication.h>
#include <tdeprocess.h>

#include <tqfileinfo.h>
#include <tqdir.h>
#include <tqfile.h>
#include <tqregexp.h>
#include <tqtextstream.h>
#include <tqstring.h>

#include <stdlib.h>

using namespace KBabel;

Msgfmt::Msgfmt(TQObject* parent,const char* name)
      : TQObject(parent , name)
{
}

Msgfmt::Status Msgfmt::checkSyntax(TQString file,TQString& output, bool gnu)
{
   Status stat=Ok;
   // this method does not return the right retrun values at the moment :-(

   TDEProcess proc;

   connect(&proc,TQ_SIGNAL(receivedStdout(TDEProcess*, char*, int)),
            this,TQ_SLOT(addToOutput(TDEProcess*,char *, int )));
   connect(&proc,TQ_SIGNAL(receivedStderr(TDEProcess *, char *, int)),
            this,TQ_SLOT(addToOutput(TDEProcess*,char *, int)));

   // remove last output
   _output="";


   proc << "msgfmt" << "--statistics" << "-o" << "/dev/null" << file;
   
   if( gnu )
   {
	proc << "-vc";
   }

   if(!proc.start(TDEProcess::Block,TDEProcess::Stderr))
   {
      stat=NoExecutable;
   }
   else if(proc.normalExit())
   {
       if( proc.exitStatus() || _output.contains(TQRegExp("^.+:\\d+:")) ) // little workaround :-(
         stat=SyntaxError;
   }
   else
      stat=Error;

   output=_output;


   return stat;
}

Msgfmt::Status Msgfmt::checkSyntaxInDir(TQString dir,TQString regexp,TQString& output)
{
   Status stat=Ok;

   // this method does not return the right return values at the moment :-(
   TDEProcess proc;
   proc.setUseShell(true);

   connect(&proc,TQ_SIGNAL(receivedStdout(TDEProcess*, char*, int)),
            this,TQ_SLOT(addToOutput(TDEProcess*,char *, int )));
   connect(&proc,TQ_SIGNAL(receivedStderr(TDEProcess *, char *, int)),
            this,TQ_SLOT(addToOutput(TDEProcess*,char *, int)));

   // remove last output
   _output="";

   proc << "IFS='\n'; msgfmt --statistics -o /dev/null "
           "$(find" << TDEProcess::quote(dir) << "-name" << TDEProcess::quote(regexp) << ")";

   if(!proc.start(TDEProcess::Block,TDEProcess::Stderr))
   {
      stat=NoExecutable;
   }
   else if(proc.normalExit())
   {
       if( proc.exitStatus() || _output.contains(TQRegExp("^.+:\\d+:")) ) // little workaround :-(
         stat=SyntaxError;
   }
   else
      stat=Error;

   output=_output;


   return stat;
}



void Msgfmt::addToOutput(TDEProcess*,char *buffer, int buflen)
{
   TQString newString = TQString::fromLocal8Bit(buffer, buflen);

   _output+=newString;
}


TQString Msgfmt::tempSaveName()
{
   return tdeApp->tempSaveName("/tmp/kbabel_msgfmt.po");
}

#include "msgfmt.moc"
