/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

#ifndef CODEVIEWERSTATE_H
#define CODEVIEWERSTATE_H

#include <tqcolor.h>
#include <tqfont.h>

namespace Settings {

/// configurable params for the code viewer tool
struct CodeViewerState {
    int height;
    int width;
    bool showHiddenBlocks;
    bool blocksAreHighlighted;
    TQFont font;
    TQColor paperColor;
    TQColor fontColor;
    TQColor selectedColor;
    TQColor editBlockColor;
    TQColor nonEditBlockColor;
    TQColor umlObjectColor;
    TQColor hiddenColor;
};

}

#endif // CODEVIEWERSTATE_H
