/***************************************************************************
 *   Copyright (C) 2000-2001 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeinstance.h>
#include <tdestandarddirs.h>
#include <kdevplugininfo.h>
#include "javasupportfactory.h"

static const KDevPluginInfo pluginData("kdevjavasupport");
K_EXPORT_COMPONENT_FACTORY( libkdevjavasupport, JavaSupportFactory )

JavaSupportFactory::JavaSupportFactory()
    : KDevGenericFactory<JavaSupportPart>( pluginData )
{
}

TDEInstance *JavaSupportFactory::createInstance()
{
    TDEInstance *instance = KDevGenericFactory<JavaSupportPart>::createInstance();
    TDEStandardDirs *dirs = instance->dirs();
    dirs->addResourceType( "newclasstemplates", TDEStandardDirs::kde_default("data") + "kdevjavasupport/newclass/" );
    dirs->addResourceType( "pcs", TDEStandardDirs::kde_default( "data" ) + "kdevjavasupport/pcs/" );

    return instance;
}

const KDevPluginInfo *JavaSupportFactory::info()
{
    return &pluginData;
}

