/* This file is part of the KDE project
   Copyright (C) 2004 Alexander Dymo <adymo@kdevelop.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef KDEVVCSINTEGRATOR_H
#define KDEVVCSINTEGRATOR_H

#include <tqobject.h>

/**
@file kdevvcsintegrator.h
The interface to VCS integrators.
*/

class TQDomDocument;
class TQWidget;

/**
VCS Integration Dialog.

Usually it is created as:
@code
class MyVCSDialog: public TQWidget, public VCSDialog {
    MyVCSDialog(TQWidget *parent = 0, const char *name = 0);
    virtual void accept() { ... }
    virtual void init(const TQString &projectName, const TQString &projectLocation) { ... }
    virtual TQWidget *self() {
        return const_cast<MyVCSDialog*>(this);
    }
}
@endcode
*/
class VCSDialog {
public:
    VCSDialog() { }
    /**Implement all integration actions here. Do not use TQDialog::accept method
    to perform integration actions.*/
    virtual void accept() = 0;
    /**Init integration dialog with the project name and location.*/
    virtual void init(const TQString &projectName, const TQString &projectLocation) = 0;
    /**Reimplement to return an actual integration widget. Use TQWidgets for that, not
    TQDialogs because integrator dialogs are usually have parent containers.*/
    virtual TQWidget *self() = 0;
};

/**
The interface to VCS integrators.
VCS integrator takes care about setting up VCS for new and existing projects.
It can, for example, perform checkout or import operations.
*/
class KDevVCSIntegrator: public TQObject {
    TQ_OBJECT
  
public:
    KDevVCSIntegrator(TQObject *parent = 0, const char *name = 0);

    /**Reimplement to return a dialog to fetch the project from VCS.*/
    virtual VCSDialog *fetcher(TQWidget *parent) = 0;
    /**Reimplement to return a dialog to integrate the project into VCS.*/
    virtual VCSDialog *integrator(TQWidget *parent) = 0;
};

#endif
