/***************************************************************************
 *   Copyright (C) 2004 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGS_H
#define TAGS_H

#include <tqvaluelist.h>
#include <tqcstring.h>
#include <tqstring.h>
#include <tqstringlist.h>

class Tags
{
public:

	struct TagEntry
	{
		TagEntry();
		TagEntry( const TQString & tag, const TQString & type, const TQString & file, const TQString & pattern );
		
		TQString tag;
		TQString type;
		TQString file;
		TQString pattern;
	};
	
	typedef TQValueList<TagEntry> TagList;
	
	/**
	 *    Method to set the tag database filename
	 * @param file the tag database filename
	 */
	static void setTagFiles(const TQStringList& tagFiles);
	
	static TQStringList getTagFiles();
	
	/**
	 *    Method to check if the tag database contains a specific tag
	 * @param tag Tag to look up
	 * @return returns true if tag database contains 'tag'
	 */
	static bool hasTag( const TQString & tag );
	
	static unsigned int numberOfPartialMatches( const TQString & tagpart );
	static unsigned int numberOfExactMatches( const TQString & tag );
	static unsigned int numberOfMatches( const TQString & tagpart, bool partial );
	
	static TagList getPartialMatches( const TQString & tagpart );
	static TagList getExactMatches( const TQString & tag );
	static TagList getMatches( const TQString & tagpart, bool partial, const TQStringList & types = TQStringList() );	

private:
	static Tags::TagList getMatches(const char* tagFile, 
								   const TQString & tagpart, 
								   bool partial,
								   const TQStringList & types );
	static unsigned int numberOfMatches(const char* tagFile, 
									   const TQString & tagpart, 
									   bool partial );
	static bool hasTag(const char* tagFile, const TQString & tag );
	static TQStringList _tagFiles;
};

#endif
