/***************************************************************************
 *   Copyright (C) 2003 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef FCCONFIGWIDGET_H
#define FCCONFIGWIDGET_H

#include <tqwidget.h>
#include <tqvaluelist.h>
#include <kurl.h>

#include "fcconfigwidgetbase.h"

class FileCreatePart;
class TQListView;
class TQDomDocument;
class TQDomElement;

namespace FileCreate{
class FileType;
}

class FCConfigWidget : public FCConfigWidgetBase
{
TQ_OBJECT
  
public:
    FCConfigWidget(FileCreatePart * part, bool global, TQWidget *parent, const char *name);

    ~FCConfigWidget();

public slots:
    void accept();
    void removetemplate_button_clicked();
    void copyToProject_button_clicked();
    void newtype_button_clicked();
    void newsubtype_button_clicked();
    void remove_button_clicked();
    void moveup_button_clicked();
    void movedown_button_clicked();
    void edittype_button_clicked();
    void newtemplate_button_clicked();
    void edittemplate_button_clicked();
    void edit_template_content_button_clicked();
    void edit_type_content_button_clicked();

protected:
    void loadGlobalConfig(TQListView *view, bool checkmarks = false);
    void loadProjectConfig(TQListView *view);
    void loadProjectTemplates(TQListView *view);
    void saveGlobalConfig();
    void saveProjectConfig();
    void loadFileTypes(TQPtrList<FileCreate::FileType> list, TQListView *view, bool checkmarks = false);
    void copyTemplate(TQString templateUrl, TQString dest, TQString destName);
    void saveConfiguration(TQDomDocument &dom, TQDomElement &element, bool global);

private:
    FileCreatePart * m_part;
    TQPtrList<FileCreate::FileType> m_globalfiletypes;
    TQPtrList<FileCreate::FileType> m_projectfiletypes;
    TQPtrList<FileCreate::FileType> m_projectfiletemplates;
    bool m_global;

    TQValueList<KURL> urlsToEdit;
};

#endif
