/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@kdevelop.org                                                    *
 *   Copyright (C) 2004                                                    *
 *   Mickael Marchand <marchand@kde.org>                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "svnintegratordlg.h"
#include "blockingtdeprocess.h"
#include <kurl.h>
#include <tdeio/jobclasses.h>
#include <tdeio/job.h>
#include <kurlrequester.h>
#include <kdebug.h>
#include <tqradiobutton.h>
#include <tdeio/scheduler.h>
#include <tdeprocess.h>
#include <tdeversion.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <kdebug.h>

#include <tdeio/netaccess.h>

using namespace TDEIO;

SvnIntegratorDlg::SvnIntegratorDlg( TQWidget *parent, const char *name )
        : SvnIntegratorDlgBase( parent, name )
{
    repos1->setMode( KFile::Directory );
}

void SvnIntegratorDlg::accept()
{
    // to let ioslave know which protocol it should start.
    KURL protocolUrl = KURL("kdevsvn+svn://blah/");
    KURL servURL( repos1->url() );
    if ( servURL.isEmpty() ) return;
    
    kdDebug( 9036 ) << "servURL : " << servURL.prettyURL() << endl;
    if ( createProject->isChecked() )
    {
        KURL::List list;
        list << servURL; // project root directory
        KURL miscURL = servURL.url();
        miscURL.setPath( servURL.path() + "/tags/" );
        list << miscURL;
        miscURL.setPath( servURL.path() + "/branches/" );
        list << miscURL;
        miscURL.setPath( servURL.path() + "/trunk/" );
        list << miscURL;

        TQByteArray parms;
        TQDataStream s( parms, IO_WriteOnly );
        int cmd = 10; // MKDIR(list)
        s << cmd << list;
        TDEIO::SimpleJob* job = TDEIO::special( protocolUrl, parms, true );
        if( !NetAccess::synchronousRun( job, 0 ) ){
            KMessageBox::error( this, i18n("Unable to create project directories on repository") );
            return;
        }

        TQByteArray parms2;
        TQDataStream s2( parms2, IO_WriteOnly );
        cmd = 5; //IMPORT
        servURL.setPath( servURL.path() + "/trunk/" );
        s2 << cmd << servURL << KURL::fromPathOrURL( m_projectLocation );
        TDEIO::SimpleJob* importJob = TDEIO::special( protocolUrl, parms2, true );
        if( !NetAccess::synchronousRun( importJob, 0 ) ){
            KMessageBox::error( this, i18n("Unable to import into repository.") );
            return;
        }
    }
    //delete the template directory and checkout a fresh one from the server
    BlockingTDEProcess *rmproc = new BlockingTDEProcess();
    *rmproc << "rm";
    *rmproc << "-f" << "-r" << m_projectLocation;
    rmproc->start();
    
    delete rmproc;
    rmproc = NULL;

    TQByteArray parms3;
    TQDataStream s3( parms3, IO_WriteOnly );
    int cmd2 = 1; //CHECKOUT
    int rev = -1;
    
    s3 << cmd2 << servURL << KURL::fromPathOrURL( m_projectLocation ) << rev << TQString( "HEAD" );
    SimpleJob *job2 = TDEIO::special( protocolUrl, parms3, true );
    if( ! NetAccess::synchronousRun( job2, 0 ) ){
        // Checkout failed
        KMessageBox::error(this, i18n("Unable to checkout from repository.") );
        return;
    }
}

void SvnIntegratorDlg::init( const TQString &projectName, const TQString &projectLocation )
{
    m_name = projectName;
    m_projectLocation = projectLocation;
}

TQWidget *SvnIntegratorDlg::self()
{
    return const_cast<SvnIntegratorDlg*>( this );
}

#include "svnintegratordlg.moc"
