/***************************************************************************
*   Copyright (C) 2003 by Roberto Raggi                                   *
*   roberto@kdevelop.org                                                  *
*                                                                         *
*   Copyright (C) 2006 by Jens Dagerbo                                    *
*   jens.dagerbo@swipnet.se                                               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include <tdelistbox.h>
#include <kcombobox.h>
#include <tdeapplication.h>
#include <tdestandarddirs.h>
#include <kurlrequester.h>
#include <kdebug.h>
#include <klineedit.h>
#include <tdemessagebox.h>
#include <tdelocale.h>

#include <tqfile.h>
#include <tqdir.h>
#include <tqregexp.h>
#include <cstdlib>

#include "settingsdialog.h"

TQListBoxItem* TQListBox_selectedItem( TQListBox* cpTQListBox )
{
	if ( cpTQListBox->selectionMode() != TQListBox::Single )
		return 0;
	if ( cpTQListBox->isSelected( cpTQListBox->currentItem() ) )
		return cpTQListBox->item( cpTQListBox->currentItem() );
	return 0;
}

SettingsDialog::SettingsDialog( TQWidget* parent, const char* name, WFlags fl )
: SettingsDialogBase( parent, name, fl )
{
	tdeApp->dirs()->addResourceType("include","include");
	TQStringList tdedirs=tdeApp->dirs()->findDirs("include","");
	for( TQStringList::Iterator it=tdedirs.begin(); it!=tdedirs.end();    ++it )
	{
		TQString tdedir = *it;
		if ( !tdedir.isEmpty() && isValidKDELibsDir( tdedir ) )
			if ( !kdeListBox->findItem( tdedir, ExactMatch ) )
				kdeListBox->insertItem( tdedir );
	}

	kdeUrl->setMode( KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly );

	connect( addUrlButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(addUrlButton_clicked()) );
}

SettingsDialog::~SettingsDialog()
{}

void SettingsDialog::slotSelectionChanged( TQListBoxItem* )
{
	emit enabled( kdeListBox->selectedItem() != 0 );
}

bool SettingsDialog::isValidKDELibsDir( const TQString & path ) const
{
	return TQFile::exists( path + "/tdeapplication.h" );
}

TQString SettingsDialog::kdeDir( ) const
{
	return kdeListBox->currentText();
}

void SettingsDialog::addUrlButton_clicked()
{
	kdDebug(9000) << k_funcinfo << endl;

	if ( isValidKDELibsDir( kdeUrl->url() ) )
	{
		kdeListBox->insertItem( kdeUrl->url() );
		if ( TQListBoxItem * item = kdeListBox->findItem( kdeUrl->url(), ExactMatch ) )
		{
			kdeListBox->setSelected( item, true );
		}
		kdeUrl->lineEdit()->clear();
	}
	else
	{
		KMessageBox::error( this, i18n("This does not appear to be a valid TDE include directory.\nPlease select a different directory."), i18n("Invalid Directory") );
	}
}


#include "settingsdialog.moc"
