// Illustrates basic usage of custom signals.
// Also see the t7 tutorial.

namespace QtSamples {
	using System;
	using Qt;

	[DeclareQtSignal ("MySignal()")]
	public class EmitSample: TQVBox {
		public EmitSample (): this (null, "") {}

		public EmitSample (TQWidget parent, string name): base ()
		{
			TQPushButton pb = new TQPushButton ("Papa Smurf", this);

			Connect (pb, TQ_SIGNAL ("clicked ()"), TQ_SLOT ("DoEmit ()"));
			Connect (this, TQ_SIGNAL ("MySignal ()"), TQ_SLOT ("PrintStuff ()"));
		}

		public void DoEmit ()
		{
			Emit ("MySignal()");
		}

		public void PrintStuff ()
		{
			Console.WriteLine ("Emitted MySignal");
		}

		public static int Main (string[] args)
		{
			TQApplication app = new TQApplication (args);
			EmitSample es = new EmitSample ();
			app.SetMainWidget (es);
			es.Show ();
			int ret = app.Exec ();
			es.Dispose();
			return ret;
		}
	}
}
