import org.trinitydesktop.qt.*;
import org.trinitydesktop.koala.*;

/**
 *  Class to test KProgress widget.
 *
 *  This is a translation to java from kprogresstest.cpp in the tests library
 *  of tdeui source.
 *
 * @see KProgress
 * @see TDEApplication
 *
 * @author orignal unknown, java translation Kenneth J. Pouncey, kjpou@hotmail.com
 * @version 0.1
 */

public class KProgressTest {

   static String description = "Java KProgress test program";
   static String[][] options = {   };
   static String VERSION = "0.1";

   public static void main(String[] cmdLineArgs) {

      TDEAboutData aboutData = new TDEAboutData( "kprogresstest", "KProgressTest",
         VERSION, description, TDEAboutData.License_GPL,
         "(c) 2002, Kenneth J. Pouncey");
      aboutData.addAuthor("Kenneth J. Pouncey",null, "kjpou@hotmail.com");
      TDECmdLineArgs.init( cmdLineArgs, aboutData );
      TDECmdLineArgs.addCmdLineOptions( options ); // Add our own options.

      TDEApplication app = new TDEApplication();

      // parse the args
      TDECmdLineArgs args = TDECmdLineArgs.parsedArgs();

      MyWidget mine = new MyWidget();

      mine.setCaption(description);

      app.setMainWidget(mine);
      mine.show();

      app.exec();

      return;
   }

   private static class MyWidget extends TQWidget {

      private KProgress Progress;
      static int fwd = 0;
      static int back = 1;
      static int direction = fwd;

      public MyWidget () {
         super();
         setFixedSize(440, 80);
         Progress = new KProgress(this);
         Progress.resize(400, 40);
         Progress.move(20, 20);
         startTimer(50);
      }

      public void timerEvent(TQTimerEvent timer) {

         if (direction == fwd)  {
            if (Progress.progress() == Progress.totalSteps())
                direction = back;
            else
                Progress.advance(1);
         }
         else {
            if (Progress.progress() == 0)  { /*Progress.minValue()*/
               direction = fwd;
            }
            else
               Progress.advance(-1);
        }
      }
   }

   static {
      qtjava.initialize();
      tdejava.initialize();
   }

}
