/*
	smpppdclient.cpp
 
	Copyright (c) 2006      by Heiko Schaefer        <heiko@rangun.de>
 
	Kopete    (c) 2002-2006 by the Kopete developers <kopete-devel@kde.org>
 
	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; version 2 of the License.               *
	*                                                                       *
	*************************************************************************
*/

#include <kstreamsocket.h>

#include "smpppdunsettled.h"
#include "smpppdclient.h"

using namespace SMPPPD;

Client::Client()
        : m_state(NULL), m_sock(NULL), m_serverID(TQString()), m_serverVer(TQString()), m_password(TQString()) {
    changeState(Unsettled::instance());
}

Client::~Client() {
    disconnect();
}

bool Client::connect(const TQString& server, uint port) {
    return m_state->connect(this, server, port);
}

void Client::disconnect() {
    m_state->disconnect(this);
}

TQStringList Client::getInterfaceConfigurations() {
    return m_state->getInterfaceConfigurations(this);
}

bool Client::statusInterface(const TQString& ifcfg) {
    return m_state->statusInterface(this, ifcfg);
}

TQString Client::serverID() const {
    return m_serverID;
}

TQString Client::serverVersion() const {
    return m_serverVer;
}

TQStringList Client::read() const {
    TQStringList qsl;

    if(isReady()) {
        TQDataStream stream(m_sock);
        char s[1024];

        stream.readRawBytes(s, 1023);
        char *sp = s;

        for(int i = 0; i < 1024; i++) {
            if(s[i] == '\n') {
                s[i] = 0;
                qsl.push_back(sp);
                sp = &(s[i+1]);
            }
        }
    }

    return qsl;
}

void Client::write(const char * cmd) {
    if(isReady()) {
        TQDataStream stream(m_sock);
        stream.writeRawBytes(cmd, strlen(cmd));
        stream.writeRawBytes("\n", strlen("\n"));
        m_sock->flush();
    }
}

bool Client::isReady() const {
    return m_sock && m_sock->state() == KNetwork::KStreamSocket::Connected;
}

bool Client::isOnline() {
	
    if(isReady()) {
        TQStringList ifcfgs = getInterfaceConfigurations();
        for(uint i = 0; i < ifcfgs.count(); i++) {
            if(statusInterface(ifcfgs[i])) {
                return true;
            }
        }
    }

    return false;
}
