/*
    Kopete GroupWise Protocol
    gweditaccountwidget.h - widget for adding or editing GroupWise accounts

    Copyright (c) 2004      SUSE Linux AG	 	 http://www.suse.com
    
    Based on Testbed   
    Copyright (c) 2003      by Will Stephenson		 <will@stevello.free-online.co.uk>
    
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef TESTBEDEDITACCOUNTWIDGET_H
#define TESTBEDEDITACCOUNTWIDGET_H

#include <tqwidget.h>
#include <editaccountwidget.h>

class TQVBoxLayout;
namespace Kopete { class Account; }
class GroupWiseAccountPreferences;

/**
 * A widget for editing this protocol's accounts
 * @author Will Stephenson
*/
class GroupWiseEditAccountWidget : public TQWidget, public KopeteEditAccountWidget
{
TQ_OBJECT
  
public:
    GroupWiseEditAccountWidget( TQWidget* parent, Kopete::Account* account);

    ~GroupWiseEditAccountWidget();

	/**
	 * Make an account out of the entered data
	 */
	virtual Kopete::Account* apply();
	/**
	 * Is the data correct?
	 */
	virtual bool validateData();
protected slots:
	void configChanged();
protected:
	bool settings_changed;
	GroupWiseAccount * account();
	void reOpen();
	void writeConfig();
	Kopete::Account *m_account;
	TQVBoxLayout *m_layout;
	GroupWiseAccountPreferences *m_preferencesDialog;
};

#endif
