/* ascii table for ksirc - Robbie Ward <linuxphreak@gmx.co.uk>*/

#include "charSelector.h"
#include "charSelector.moc"

#include <tqlayout.h>
#include <tqpushbutton.h>

#include <tdelocale.h>

charSelector::charSelector(TQWidget *parent, const char* name)
           : KDialog(parent, name, false)
{
  testLayout = new TQVBoxLayout(this);
  testLayout->setSpacing( spacingHint() );
  testLayout->setMargin( marginHint() );

  charSelect = new KCharSelect(this, TQCString(name) + "_kcharselector", "", 0);
  testLayout->addWidget(charSelect);
  charSelect->installEventFilter(this);

  connect(charSelect, TQ_SIGNAL(doubleClicked()), TQ_SLOT(insertText()));

  TQHBoxLayout *buttonLayout = new TQHBoxLayout;
  buttonLayout->setSpacing( spacingHint() );

  insertButton = new TQPushButton(i18n("&Insert Char"), this);
  connect(insertButton, TQ_SIGNAL(clicked()), TQ_SLOT(insertText()));
  buttonLayout->addWidget(insertButton);

  TQSpacerItem *spacer = new TQSpacerItem(50, 20, TQSizePolicy::Expanding, TQSizePolicy::Expanding);
  buttonLayout->addItem(spacer);

  testLayout->addLayout(buttonLayout);
}

charSelector::~charSelector()
{
    delete charSelect;
    charSelect = 0x0;
}

void charSelector::insertText()
{
  emit clicked();
}

void charSelector::setFont( const TQString &font )
{
    charSelect->setFont(font);
}

void charSelector::reject()
{
    KDialog::reject();
    close();
}

void charSelector::keyPressEvent(TQKeyEvent *e)
{
    KDialog::keyPressEvent(e);
}

bool charSelector::eventFilter ( TQObject *, TQEvent * e )
{
    if ( e->type() == TQEvent::AccelOverride ) {
	// special processing for key press
	TQKeyEvent *k = (TQKeyEvent *)e;
	if(k->key() == Key_Escape){
            keyPressEvent(k);
	    return TRUE; // eat event
	}
    }
    // standard event processing
    return FALSE;
}

