#!/usr/bin/env kjscmd

StdDirs.addResourceType("madminute", StdDirs.kde_default("data") + "/madminute");
try {
	//var view = Factory.loadui( StdDirs.findResource("madminute", "madminute.ui"), this, mw );
	var view = Factory.loadui( "madminute.ui" );

} catch( err ) {
	alert( err );
	exit(0);
}
var Addition = 1;
var Subtraction = 2;

var config = new Config("madminute");
config.setGroup("Game Options");
// Timer
var timer = new TQTimer(this);
// Current Argument 1
var arg1 = 0;
// Current Argument 2
var arg2 = 0;
// Current Operation
var operation = Addition;
// Acceptable operations 1 = Addition 2 = Subtraction 3 = Both
var operations = config.readNumEntry("Operations", Addition);
// Time to run the drill
var drillTime = config.readNumEntry("Drill Time", 60);
// maxInput is maximum value for the numbers in the question
var maxInput = config.readNumEntry("Maximum Input", 10);
var total = 0;

view.connect(view.fileExitAction, 'activated()', application, 'quit()');
view.connect(view.fileGoAction, 'activated()', this, 'start');
view.connect(view.editPreferencesAction, 'activated()', this, 'configure');
view.connect(view.helpAboutAction, 'activated()', this, 'about');
view.connect(view.helpHelpAction, 'activated()', this, 'helpDialog');


view.connect( view.qt_central_widget.answer, 'returnPressed()', this, 'checkAnswer' );
view.connect( timer, 'timeout()', this, 'countdown');

view.qt_central_widget.answer.enabled = false;

view.show();
// Run the main event loop.
application.exec();

function configure()
{
	//var configUI = Factory.loadui( StdDirs.findResource("madminute", "configdialog.ui"), this, mw );
	var configUI = Factory.loadui( "configdialog.ui" );
	configUI.connect( configUI.buttonHelp, 'clicked()', this, 'helpDialog');
	configUI.addition.checked = false;
	configUI.subtraction.checked == false;
	configUI.time.value = drillTime;
	configUI.maximum.value = maxInput;
	if( operations == 1 )
		configUI.addition.checked = true;
	if( operations == 2 )
		configUI.subtraction.checked = true;
	if( operations == 3 )
	{
		configUI.addition.checked = true;
		configUI.subtraction.checked = true;
	}

	if ( configUI.exec() == 1 )
	{
		operations = 0;
		if( configUI.addition.checked == true )
			operations += 1;
		if( configUI.subtraction.checked == true )
			operations += 2;
		drillTime = configUI.time.value;
		maxInput = configUI.maximum.value;
		config.setGroup("Game Options");
		config.writeNumEntry("Operations",operations);
		config.writeNumEntry("Drill Time", drillTime );
		config.writeNumEntry("Maximum Input", maxInput );
		config.sync();
	}
}

function about()
{
	alert("<h2>MadMinute 1.0</h2>A math tutoring drill to help students master basic math skills.<br>Copyright 2004 Ian Reinhart Geiser <a href='mailto:geiseri@kde.org'>geiseri@kde.org</a>");
}

function helpDialog()
{
	//var helpUI = Factory.loadui( StdDirs.findResource("madminute", "helpdialog.ui"), this, mw );
	var helpUI = Factory.loadui( "helpdialog.ui" );
	helpUI.exec();
}

function askQuestion()
{
	arg1 = Math.floor( Math.random() * maxInput );
	arg2 = Math.floor( Math.random() * maxInput );
	if( operations == 3 )
		operation = Math.floor( (Math.random() * 2)+1);
	else
		operation = operations;

	var operationText = "";
	if( operation == Addition )
		operationText = " + ";
	else if( operation == Subtraction )
	{
		operationText = " - ";
		if( arg1 < arg2 )
		{
			var arg = arg1;
			arg1 = arg2;
			arg2 = arg;
		}
	}
	view.qt_central_widget.question.text = "<h2>" + arg1 + operationText + arg2 + "=</h2>";
}

function checkAnswer( )
{
	var answer = 0;
	if( operation == Addition )
		answer = (arg1 + arg2) ;
	else if( operation == Subtraction )
		answer = (arg1 - arg2) ;
	if( view.qt_central_widget.answer.text == answer )
	{
		view.qt_central_widget.correct.value++;
	}
	total++;
	askQuestion();
	view.qt_central_widget.answer.text = "";
}

function start()
{
	askQuestion();
	total = 0;
	timer.start(1000);
	view.fileGoAction.enabled = false;
	view.qt_central_widget.answer.enabled = true;
	view.qt_central_widget.answer.setFocus();
	view.qt_central_widget.timeleft.progress = drillTime;
	view.qt_central_widget.correct.value = 0;
}

function countdown()
{
	view.qt_central_widget.timeleft.progress--;
	if( view.qt_central_widget.timeleft.progress == 0 )
	{
		timer.stop();
		view.fileGoAction.enabled = true;
		view.qt_central_widget.answer.enabled = false;
		alert( "<h1>Times Up!</h1>You got " + view.qt_central_widget.correct.value + " out of " + total + " questions correct." );
	}
}

