
#ifndef GAMEWIDGET_H
#define GAMEWIDGET_H

class Feld;
class Molek;
class TQScrollBar;
class TQLabel;
class KScoreDialog;

#include <tqwidget.h>

class GameWidget : public TQWidget
{
    TQ_OBJECT
  

 public:

    GameWidget ( TQWidget *parent, const char *name=0 );

    ~GameWidget();

 signals:
    void enableRedo(bool enable);
    void enableUndo(bool enable);

 public slots:
    // bringt level auf neuesten stand
    void updateLevel (int);

    // copy highscores from "High Scores" key to "Highscores" key
    void mergeHighScores(int l);

    // restart current level
    void restartLevel();

    // getbutton erhlt button der gedrckt wurde
    void getButton (int);

    void gameOver(int moves);

    // use this slot to update the moves continually
    void getMoves(int moves);

    // Menupunkt Highscores im Pop-up Menu, der Highscore anzeigt
    void showHighscores ();

    void moveUp();
    void moveDown();
    void moveLeft();
    void moveRight();
    void nextAtom();
    void previousAtom();
    void doUndo ();
    void doRedo ();

 protected:

    // stellt das spielfeld dar !
    Feld *feld;

    // stellt molekl dar
    Molek *molek;

    // scorllbar zur levelwahl
    TQScrollBar *scrl;

    // important labels : highest and current scores
    TQLabel *hs, *ys;
    TQString highest, current;

    int nlevels;

    KScoreDialog *highScore;
};

#endif
