/***************************************************************************
                          TWin4  -  Four in a Row for TDE
                             -------------------
    begin                : March 2000 
    copyright            : (C) 1995-2001 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <kdebug.h>
#include <tdeaboutdata.h>

#include "twin4.h"

#define TWIN4_VERSION "v1.10"

static TDECmdLineOptions options[] =
{
  { "d", 0, 0},
  { "debug <level>", I18N_NOOP("Enter debug level"), 0 },
  TDECmdLineLastOption
};

int global_debug;

int main(int argc, char *argv[])
{
  global_debug=0;
  TDEAboutData aboutData( "twin4", I18N_NOOP("TWin4"),
                        TWIN4_VERSION,
                        I18N_NOOP("TWin4: Two player network game"),
                        TDEAboutData::License_GPL,
                        "(c) 1995-2000, Martin Heni");
  aboutData.addAuthor("Martin Heni",0, "martin@heni-online.de");
  aboutData.addCredit("Laura", I18N_NOOP("Beta testing"), 0);
  aboutData.addAuthor("Benjamin Meyer", I18N_NOOP("Code Improvements"), 0);
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  /* command line handling */
  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  if (args->isSet("debug"))
  {
    global_debug=TQString(args->getOption("debug")).toInt();
    kdDebug(12010) << "Debug level set to " << global_debug << endl;
  }
  args->clear(); 
  TDEApplication app(argc, argv);
  TDEGlobal::locale()->insertCatalogue("libtdegames");

  if (app.isRestored())
  {
    RESTORE(Kwin4App);
  }
  else
  {
    Kwin4App *twin4 = new Kwin4App();
    app.setMainWidget(twin4);
    twin4->show();
  }

  return app.exec();
}

