/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>
    Copyright (c) 2004 Till Adam <adam@kde.org>
    Copyright (c) 2005 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "kcal_cachesettingsdlg.h"

#include "kcal_resourcegroupwarebase.h"
#include "tderesources_groupwareprefs.h"

#include <libkcal/resourcecachedconfig.h>

#include <tdelocale.h>
#include <kdebug.h>
#include <klineedit.h>
#include <kdialog.h>

#include <tqlabel.h>
#include <tqlayout.h>


using namespace KCal;

CacheSettingsDialog::CacheSettingsDialog( TQWidget* parent, const char* name )
    : KDialogBase( parent, name, true, i18n("Resource Cache Settings"), KDialogBase::Close )
{
  TQWidget *mainWidget = new TQWidget( this );
  setMainWidget( mainWidget );

  TQGridLayout *mainLayout = new TQGridLayout( mainWidget, 2, 2 );
  mainLayout->setSpacing( KDialog::spacingHint() );

  mReloadConfig = new KCal::ResourceCachedReloadConfig( mainWidget );
  mainLayout->addMultiCellWidget( mReloadConfig, 1, 3, 2, 2 );

  mSaveConfig = new KCal::ResourceCachedSaveConfig( mainWidget );
  mainLayout->addMultiCellWidget( mSaveConfig, 4, 4, 2, 2 );
}

void CacheSettingsDialog::loadSettings( KRES::Resource *resource )
{
  kdDebug(7000) << "KCal::CacheSettingsDialog::loadSettings()" << endl;

  ResourceGroupwareBase *res = static_cast<ResourceGroupwareBase *>( resource );
  if ( res ) {
    if ( !res->prefs() ) {
      kdError() << "No PREF" << endl;
      return;
    }
    
    mReloadConfig->loadSettings( res );
    mSaveConfig->loadSettings( res );
    
  } else {
    kdError(5700) << "CacheSettingsDialog::loadSettings(): "
                     "no ResourceGroupwareBase, cast failed" << endl;
  }
}

void CacheSettingsDialog::saveSettings( KRES::Resource *resource )
{
  ResourceGroupwareBase *res = static_cast<ResourceGroupwareBase*>( resource );
  if ( res ) {
    mReloadConfig->saveSettings( res );
    mSaveConfig->saveSettings( res );
  } else {
    kdError(5700) << "CacheSettingsDialog::saveSettings(): "
                     "no ResourceGroupwareBase, cast failed" << endl;
  }
}

#include "kcal_cachesettingsdlg.moc"
