/***************************************************************************
                                diffmodel.h  -  description
                                -------------------
        begin                   : Sun Mar 4 2001
        copyright               : (C) 2001-2004 Otto Bruggeman
                                  (C) 2001-2003 John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#ifndef DIFFMODEL_H
#define DIFFMODEL_H

#include <tqobject.h>
#include <tqstringlist.h>

#include "diffhunk.h"
#include "kompare.h"

namespace Diff2
{

class DiffHunk;
class Difference;

class DiffModel : public TQObject
{
TQ_OBJECT
  
public:

	DiffModel( const TQString& srcBaseURL, const TQString& destBaseURL );
	DiffModel();
	DiffModel( const DiffModel& ) : TQObject() {};
	~DiffModel();

	int parseDiff( enum Kompare::Format format, const TQStringList& list );

	TQString recreateDiff() const;

	int hunkCount() const       { return m_hunks.count(); }
	int differenceCount() const { return m_differences.count(); }
	int appliedCount() const    { return m_appliedCount; }

	DiffHunk* hunkAt( int i )               { return *( m_hunks.at( i ) ); }
	const Difference* differenceAt( int i ) { return *( m_differences.at( i ) ); }

	DiffHunkList*         hunks()             { return &m_hunks; }
	const DiffHunkList*   hunks() const       { return &m_hunks; }
	DifferenceList*       differences()       { return &m_differences; }
	const DifferenceList* differences() const { return &m_differences; }

	DifferenceList*       allDifferences();

	int findDifference( Difference* diff ) const { return m_differences.findIndex( diff ); }

	Difference* firstDifference();
	Difference* lastDifference();
	Difference* prevDifference();
	Difference* nextDifference();

	const TQString source() const               { return m_source; }
	const TQString destination() const          { return m_destination; }
	const TQString sourceFile() const;
	const TQString destinationFile() const;
	const TQString sourcePath() const;
	const TQString destinationPath() const;
	const TQString sourceTimestamp() const      { return m_sourceTimestamp; }
	const TQString destinationTimestamp() const { return m_destinationTimestamp; }
	const TQString sourceRevision() const       { return m_sourceRevision; }
	const TQString destinationRevision() const  { return m_destinationRevision; }

	void setSourceFile( TQString path );
	void setDestinationFile( TQString path );
	void setSourceTimestamp( TQString timestamp );
	void setDestinationTimestamp( TQString timestamp );
	void setSourceRevision( TQString revision );
	void setDestinationRevision( TQString revision );

	void addHunk( DiffHunk* hunk );
	void addDiff( Difference* diff );
	bool isModified() const { return m_modified; }

	const int diffIndex( void ) const       { return m_diffIndex; }
	void      setDiffIndex( int diffIndex ) { m_diffIndex = diffIndex; }

	void applyDifference( bool apply );
	void applyAllDifferences( bool apply );

	bool setSelectedDifference( Difference* diff );

	DiffModel& operator=( const DiffModel& model );
	bool operator<( const DiffModel& model );

	int localeAwareCompareSource( const DiffModel& model );

	bool isBlended() const { return m_blended; }
	void setBlended( bool blended ) { m_blended = blended; }

signals:
	void setModified( bool modified );

public slots:
	void slotSetModified( bool modified );

private:
	void splitSourceInPathAndFileName();
	void splitDestinationInPathAndFileName();

private:
	TQString m_source;
	TQString m_destination;

	TQString m_sourcePath;
	TQString m_destinationPath;

	TQString m_sourceFile;
	TQString m_destinationFile;

	TQString m_sourceTimestamp;
	TQString m_destinationTimestamp;

	TQString m_sourceRevision;
	TQString m_destinationRevision;

	DiffHunkList   m_hunks;
	DifferenceList m_differences;
	DifferenceList m_allDifferences;

	int  m_appliedCount;
	bool m_modified;

	unsigned int m_diffIndex;
	Difference*  m_selectedDifference;

	bool m_blended;
};

} // End of namespace Diff2

#endif

