/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/
#ifndef _COMPOUNDWIDGET_H_
#define _COMPOUNDWIDGET_H_

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <tqwidget.h>
#include "global.h"

//	forward class definitions
//	=========================

class TDEConfig;
class TQCheckBox;
class TQLineEdit;
class TQPushButton;
class TQSpinBox;

//	CompountWidget class definition
//	===============================

class CompoundWidget : public TQWidget
{	TQ_OBJECT

	public:
		CompoundWidget( TQWidget* parent, const char* name = NULL );

		void finaliseInitialisation( );
		bool getOptions( bool& needRoot );
		void readProfile( TDEConfig* config );
		void saveProfile( TDEConfig* config );
		void setInitialValues( );

		bool    dataDirState( )        const { return m_dataDirState;        }
		TQString dataDirValue( )        const { return m_dataDirValue;        }
		bool    dataLengthState( )     const { return m_dataLengthState;     }
		int     dataLengthValue( )     const { return m_dataLengthValue;     }
		bool    decoyState( )          const { return m_decoyState;          }
		TQString decoyValue( )          const { return m_decoyValue;          }
		bool    debugLevelState( )     const { return m_debugLevelState;     }
		int     debugLevelValue( )     const { return m_debugLevelValue;     }
		bool    excludeState( )        const { return m_excludeState;        }
		TQString excludeValue( )        const { return m_excludeValue;        }
		bool    excludeFileState( )    const { return m_excludeFileState;    }
		TQString excludeFileValue( )    const { return m_excludeFileValue;    }
		bool    fragmentLevelState( )  const { return m_fragmentLevelState;  }
		int     fragmentLevelValue( )  const { return m_fragmentLevelValue;  }
		bool    interfaceState( )      const { return m_interfaceState;      }
		TQString interfaceValue( )      const { return m_interfaceValue;      }
		bool    maxSocketsState( )     const { return m_maxSocketsState;     }
		int     maxSocketsValue( )     const { return m_maxSocketsValue;     }
		bool    randomIPState( )       const { return m_randomIPState;       }
		int     randomIPValue( )       const { return m_randomIPValue;       }
		bool    sourceIPState( )       const { return m_sourceIPState;       }
		TQString sourceIPValue( )       const { return m_sourceIPValue;       }
		bool    sourcePortState( )     const { return m_sourcePortState;     }
		int     sourcePortValue( )     const { return m_sourcePortValue;     }
		bool    spoofMacState( )       const { return m_spoofMacState;       }
		TQString spoofMacValue( )       const { return m_spoofMacValue;       }
		bool    targetFileState( )     const { return m_targetFileState;     }
		TQString targetFileValue( )     const { return m_targetFileValue;     }
		bool    ttlState( )            const { return m_ttlState;            }
		int     ttlValue( )            const { return m_ttlValue;            }

	signals:
		void displayDocBook( const TQString& );
		void displayHelp( const TQString& );
		void displayUnknown( );
		void optionsDirty( );

	private slots:
		void slotDataDirButtonClicked( );
		void slotDataDirCheckBoxClicked( );
		void slotDataLengthCheckBoxClicked( );
		void slotDebugLevelCheckBoxClicked( );
		void slotDecoyButtonClicked( );
		void slotDecoyCheckBoxClicked( );
		void slotExcludeButtonClicked( );
		void slotExcludeCheckBoxClicked( );
		void slotExcludeFileButtonClicked( );
		void slotExcludeFileCheckBoxClicked( );
		void slotFragmentLevelCheckBoxClicked( );
		void slotInterfaceButtonClicked( );
		void slotInterfaceCheckBoxClicked( );
		void slotMaxSocketsCheckBoxClicked( );
		void slotRandomIPCheckBoxClicked( );
		void slotSourceIPButtonClicked( );
		void slotSourceIPCheckBoxClicked( );
		void slotSourcePortCheckBoxClicked( );
		void slotSpoofMACButtonClicked( );
		void slotSpoofMacCheckBoxClicked( );
		void slotTargetFileButtonClicked( );
		void slotTargetFileCheckBoxClicked( );
		void slotTTLCheckBoxClicked( );
		void slotWhatsThisClicked( );

	private:
		void createLayout( );

		TQPushButton* m_dataDirButton;
		TQCheckBox*   m_dataDirCheckBox;
		TQLineEdit*   m_dataDirLineEdit;
		bool         m_dataDirState;
		TQString      m_dataDirValue;
		TQCheckBox*   m_dataLengthCheckBox;
		TQSpinBox*    m_dataLengthSpinBox;
		bool         m_dataLengthState;
		int          m_dataLengthValue;
		TQPushButton* m_decoyButton;
		TQCheckBox*   m_decoyCheckBox;
		TQLineEdit*   m_decoyLineEdit;
		bool         m_decoyState;
		TQString      m_decoyValue;
		TQCheckBox*   m_debugLevelCheckBox;
		TQSpinBox*    m_debugLevelSpinBox;
		bool         m_debugLevelState;
		int          m_debugLevelValue;
		TQPushButton* m_excludeButton;
		TQCheckBox*   m_excludeCheckBox;
		TQLineEdit*   m_excludeLineEdit;
		bool         m_excludeState;
		TQString      m_excludeValue;
		TQPushButton* m_excludeFileButton;
		TQCheckBox*   m_excludeFileCheckBox;
		TQLineEdit*   m_excludeFileLineEdit;
		bool         m_excludeFileState;
		TQString      m_excludeFileValue;
		TQCheckBox*   m_fragmentLevelCheckBox;
		TQSpinBox*    m_fragmentLevelSpinBox;
		bool         m_fragmentLevelState;
		int          m_fragmentLevelValue;
		TQPushButton* m_interfaceButton;
		TQCheckBox*   m_interfaceCheckBox;
		TQLineEdit*   m_interfaceLineEdit;
		bool         m_interfaceState;
		TQString      m_interfaceValue;
		TQCheckBox*   m_maxSocketsCheckBox;
		TQSpinBox*    m_maxSocketsSpinBox;
		bool         m_maxSocketsState;
		int          m_maxSocketsValue;
		TQCheckBox*   m_randomIPCheckBox;
		TQSpinBox*    m_randomIPSpinBox;
		bool         m_randomIPState;
		int          m_randomIPValue;
		TQPushButton* m_sourceIPButton;
		TQCheckBox*   m_sourceIPCheckBox;
		TQLineEdit*   m_sourceIPLineEdit;
		bool         m_sourceIPState;
		TQString      m_sourceIPValue;
		TQCheckBox*   m_sourcePortCheckBox;
		TQSpinBox*    m_sourcePortSpinBox;
		bool         m_sourcePortState;
		int          m_sourcePortValue;
		TQPushButton* m_spoofMacButton;
		TQCheckBox*   m_spoofMacCheckBox;
		TQLineEdit*   m_spoofMacLineEdit;
		bool         m_spoofMacState;
		TQString      m_spoofMacValue;
		TQPushButton* m_targetFileButton;
		TQCheckBox*   m_targetFileCheckBox;
		TQLineEdit*   m_targetFileLineEdit;
		bool         m_targetFileState;
		TQString      m_targetFileValue;
		TQCheckBox*   m_ttlCheckBox;
		TQSpinBox*    m_ttlSpinBox;
		bool         m_ttlState;
		int          m_ttlValue;
};

#endif	// _COMPOUNDWIDGET_H_
