/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _MAIL_OPTIONS_H_
#define _MAIL_OPTIONS_H_

#include <tqframe.h>
#include <tqspinbox.h>

#include <tdepopupmenu.h>
#include <tdeconfig.h>
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <kurl.h>
#include <tdeaction.h>

#include "globals.h"
#include "specificFileList.h"
#include "logLevel.h"

class MailOptions : public TQWidget {
	TQ_OBJECT
  
	public:
		MailOptions(TQWidget *parent = 0);
		~MailOptions();
		
		bool isValid();
	public slots:
		void saveConfig();
		void readConfig();

		void slotFileListChanged(int itemLeft);

	signals:
		void optionsChanged(bool valid);

	private:

		SpecificFileList* fileList;
};

#endif
