/***************************************************************************
 *   Copyright (C) 2001-2003                                               *
 *   The KDevelop Team                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqpopupmenu.h>

#include <tdeglobal.h>
#include <tdelocale.h>
#include <kicontheme.h>
#include <kiconloader.h>

#include "kdevtabwidget.h"

KDevTabWidget::KDevTabWidget(TQWidget *parent, const char *name) : TQTabWidget(parent,name)
{
  m_pTabBar = new KTabBar(this, "tabbar");
  setTabBar(m_pTabBar);
  connect(m_pTabBar, TQ_SIGNAL(closeWindow(const TQWidget*)), this, TQ_SIGNAL(closeWindow(const TQWidget*)));
  connect(m_pTabBar, TQ_SIGNAL(closeOthers(TQWidget*)), this, TQ_SIGNAL(closeOthers(TQWidget*)));
}

KTabBar::KTabBar(TQWidget *parent, const char *name) : TQTabBar(parent,name)
{
  m_pPopupMenu = new TQPopupMenu(this);

  TQPixmap closePixmap = TDEGlobal::instance()->iconLoader()->loadIcon( "tab_remove", TDEIcon::Small, 0, TDEIcon::DefaultState, 0, true ); 
  if (closePixmap.isNull())
    closePixmap = SmallIcon("window-close");

  m_pPopupMenu->insertItem(closePixmap, i18n("&Close"), this, TQ_SLOT(closeWindowSlot()));
  m_pPopupMenu->insertItem(i18n("Close &Others"), this, TQ_SLOT(closeOthersSlot()));
}

void KTabBar::closeWindowSlot()
{
	emit closeWindow(m_pPage);
}

void KTabBar::closeOthersSlot()
{
	emit closeOthers(m_pPage);
}

void KTabBar::mousePressEvent(TQMouseEvent *e)
{
  if(e->button() == TQt::RightButton) {

    TQTab *tab = selectTab(e->pos() );
    if( tab == 0L ) return;
    
    m_pPage = ((KDevTabWidget*)parent())->page(indexOf(tab->identifier() ) );
    if(m_pPage == 0L) return;

    m_pPopupMenu->exec(mapToGlobal(e->pos()));
  }
  TQTabBar::mousePressEvent(e);
}

#include "kdevtabwidget.moc"
