/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pdatetimeedit.h"

#include <tqdatetimeedit.h>
#include <tqpainter.h>
#include <tqlayout.h>

namespace PropertyLib{

PDateTimeEdit::PDateTimeEdit(MultiProperty* property, TQWidget* parent, const char* name): PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new TQDateTimeEdit(this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);
    
    connect(m_edit, TQ_SIGNAL(valueChanged(const TQDateTime&)), this, TQ_SLOT(updateProperty(const TQDateTime&)));
}

TQVariant PDateTimeEdit::value() const
{
     return TQVariant(m_edit->dateTime());
}

void PDateTimeEdit::drawViewer(TQPainter* p, const TQColorGroup& cg, const TQRect& r, const TQVariant& value)
{
    p->setPen(TQt::NoPen);
    p->setBrush(cg.background());
    p->drawRect(r);
    p->drawText(r, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine, value.toDateTime().toString(TQt::LocalDate));
}

void PDateTimeEdit::setValue(const TQVariant& value, bool emitChange)
{
    disconnect(m_edit, TQ_SIGNAL(valueChanged(const TQDateTime&)), this, TQ_SLOT(updateProperty(const TQDateTime&)));
    m_edit->setDateTime(value.toDateTime());
    connect(m_edit, TQ_SIGNAL(valueChanged(const TQDateTime&)), this, TQ_SLOT(updateProperty(const TQDateTime&)));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PDateTimeEdit::updateProperty(const TQDateTime &val)
{
    emit propertyChanged(m_property, TQVariant(val));
}

}

#ifndef PURE_QT
#include "pdatetimeedit.moc"
#endif
