/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef BOOKMARKVIEW_H
#define BOOKMARKVIEW_H

#include <tqwidget.h>

#include <kbookmarkmanager.h>

class TDEListView;
class KPushButton;
class DocumentationPart;
class DocumentationWidget;
class TQListViewItem;

class DocBookmarkManager: public KBookmarkManager {
public:
    DocBookmarkManager(DocumentationPart *part);
};

class DocBookmarkOwner: public KBookmarkOwner {
public:
    DocBookmarkOwner(DocumentationPart *part);

    virtual void openBookmarkURL(const TQString &_url);
    virtual TQString currentTitle() const;
    virtual TQString currentURL() const;

private:
    DocumentationPart *m_part;
};

class BookmarkView : public TQWidget
{
    TQ_OBJECT
  
public:
    BookmarkView(DocumentationWidget *parent = 0, const char *name = 0);
    ~BookmarkView();
    
public slots:
    void addBookmark(const TQString &title, const KURL &url);

protected:
    void showBookmarks();
    virtual void focusInEvent(TQFocusEvent *e);

protected slots:
    void itemExecuted(TQListViewItem *item, const TQPoint &p, int col);
    void addBookmark();
    void editBookmark();
    void removeBookmark();
    void itemMouseButtonPressed(int button, TQListViewItem *item, const TQPoint &pos, int c);

private:
    DocumentationWidget *m_widget;
    TDEListView *m_view;
    KPushButton *m_addButton;
    KPushButton *m_editButton;    
    KPushButton *m_removeButton;
    
    DocBookmarkManager *m_bmManager;
    DocBookmarkOwner *m_bmOwner;
};

#endif
