/***************************************************************************
 *   Copyright (C) 2003 by Mario Scalas                                    *
 *   mario.scalas@libero.it                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VCSCOLORSCONFIGWIDGET_H
#define VCSCOLORSCONFIGWIDGET_H

#include <tqcolor.h>
#include "vcscolorsconfigwidgetbase.h"

class FileViewPart;

struct VCSColors
{
    VCSColors();
    VCSColors( const VCSColors &others );
    VCSColors &operator=( const VCSColors &others );

    TQColor modified;
    TQColor added;
    TQColor updated;
    TQColor sticky;
    TQColor conflict;
    TQColor needsPatch;
    TQColor needsCheckout;
    TQColor unknown;
    TQColor defaultColor;
};

class VCSColorsConfigWidget : public VCSColorsConfigWidgetBase
{
  TQ_OBJECT
  

public:
  VCSColorsConfigWidget( FileViewPart *part, const VCSColors &vcsColors,
      TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  virtual ~VCSColorsConfigWidget();
  /*$PUBLIC_FUNCTIONS$*/

  void getColors( VCSColors &vcsColors ) const;
  void setColors( const VCSColors &colors );

public slots:
  /*$PUBLIC_SLOTS$*/
  // Store settings if the user gives the ok
  void slotAccept();


protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/


private:
    FileViewPart *m_part;
};

#endif

