package ButtonsGroups;
use strict;
use TQt;
use TQt::isa qw(TQt::Widget);
use TQt::slots
	slotChangeGrp3State => [];
use TQt::attributes qw(
	state
	rb21
	rb22
	rb23
);

#
# Constructor
#
# Creates all child widgets of the ButtonGroups window
#

sub NEW {
    shift->SUPER::NEW(@_);

    # Create Widgets which allow easy layouting
    my $vbox = TQt::VBoxLayout(this);
    my $box1 = TQt::HBoxLayout($vbox);
    my $box2 = TQt::HBoxLayout($vbox);

    # ------- first group

    # Create an exclusive button group
    my $bgrp1 = TQt::ButtonGroup(1, &Horizontal, "Button Group &1 (exclusive)", this);
    $box1->addWidget($bgrp1);
    $bgrp1->setExclusive(1);

    # insert 3 radiobuttons
    TQt::RadioButton("R&adiobutton 2", $bgrp1);
    TQt::RadioButton("Ra&diobutton 3", $bgrp1);

    # ------- second group

    # Create a non-exclusive buttongroup
    my $bgrp2 = TQt::ButtonGroup(1, &Horizontal, "Button Group &2 (non-exclusive)", this);
    $box1->addWidget($bgrp2);
    $bgrp2->setExclusive(0);

    # insert 3 checkboxes
    TQt::CheckBox("&Checkbox 1", $bgrp2);
    my $cb12 = TQt::CheckBox("C&heckbox 2", $bgrp2);
    $cb12->setChecked(1);
    my $cb13 = TQt::CheckBox("Triple &State Button", $bgrp2);
    $cb13->setTristate(1);
    $cb13->setChecked(1);

    # ----------- third group

    # create a buttongroup which is exclusive for radiobuttons and non-exclusive for all other buttons
    my $bgrp3 = TQt::ButtonGroup(1, &Horizontal, "Button Group &3 (Radiobutton-exclusive)", this);
    $box2->addWidget($bgrp3);
    $bgrp3->setRadioButtonExclusive(1);

    # insert three radiobuttons
    rb21 = TQt::RadioButton("Rad&iobutton 1", $bgrp3);
    rb22 = TQt::RadioButton("Radi&obutton 2", $bgrp3);
    rb23 = TQt::RadioButton("Radio&button 3", $bgrp3);
    rb23->setChecked(1);

    # insert a checkbox
    state = TQt::CheckBox("E&nable Radiobuttons", $bgrp3);
    state->setChecked(1);
    # ...and connect its TQ_SIGNAL clicked() with the TQ_SLOT slotChangeGrp3State()
    this->connect(state, TQ_SIGNAL('clicked()'), TQ_SLOT('slotChangeGrp3State()'));

    # ----------- fourth group

    # create a groupbox which layouts its childs in a columns
    my $bgrp4 = TQt::ButtonGroup(1, &Horizontal, "Groupbox with &normal buttons", this);
    $box2->addWidget($bgrp4);

    # insert three pushbuttons...
    TQt::PushButton("&Push Button", $bgrp4);
    my $tb2 = TQt::PushButton("&Toggle Button", $bgrp4);
    my $tb3 = TQt::PushButton("&Flat Button", $bgrp4);

    # ... and make the second one a toggle button
    $tb2->setToggleButton(1);
    $tb2->setOn(1);

    # ... and make the third one a flat button
    $tb3->setFlat(1);
}

#
# TQ_SLOT slotChangeGrp3State()
#
# enables/disables the radiobuttons of the third buttongroup
#

sub slotChangeGrp3State {
    rb21->setEnabled(state->isChecked);
    rb22->setEnabled(state->isChecked);
    rb23->setEnabled(state->isChecked);
}

1;
