package GameBoard;
use strict;
use TQt;
use TQt::isa qw(TQt::Widget);
use TQt::slots
	fire => [],
	hit => [],
	missed => [],
	newGame => [];
use TQt::attributes qw(
	hits
	shotsLeft
	cannonField
);

use LCDRange;
use CannonField;

sub NEW {
    shift->SUPER::NEW(@_);

    my $quit = TQt::PushButton("&Quit", this, "quit");
    $quit->setFont(TQt::Font("Times", 18, &TQt::Font::Bold));

    TQt::app->connect($quit, TQ_SIGNAL('clicked()'), TQ_SLOT('quit()'));

    my $angle = LCDRange("ANGLE", this, "angle");
    $angle->setRange(5, 70);

    my $force = LCDRange("FORCE", this, "force");
    $force->setRange(10, 50);

    my $box = TQt::VBox(this, "cannonFrame");
    $box->setFrameStyle($box->WinPanel | $box->Sunken);

    cannonField = CannonField($box, "cannonField");

    cannonField->connect($angle, TQ_SIGNAL('valueChanged(int)'), TQ_SLOT('setAngle(int)'));
    $angle->connect(cannonField, TQ_SIGNAL('angleChanged(int)'), TQ_SLOT('setValue(int)'));

    cannonField->connect($force, TQ_SIGNAL('valueChanged(int)'), TQ_SLOT('setForce(int)'));
    $force->connect(cannonField, TQ_SIGNAL('forceChanged(int)'), TQ_SLOT('setValue(int)'));

    this->connect(cannonField, TQ_SIGNAL('hit()'), TQ_SLOT('hit()'));
    this->connect(cannonField, TQ_SIGNAL('missed()'), TQ_SLOT('missed()'));

    my $shoot = TQt::PushButton('&Shoot', this, "shoot");
    $shoot->setFont(TQt::Font("Times", 18, &TQt::Font::Bold));

    this->connect($shoot, TQ_SIGNAL('clicked()'), TQ_SLOT('fire()'));

    $shoot->connect(cannonField, TQ_SIGNAL('canShoot(bool)'), TQ_SLOT('setEnabled(bool)'));

    my $restart = TQt::PushButton('&New Game', this, "newgame");
    $restart->setFont(TQt::Font("Times", 18, &TQt::Font::Bold));

    this->connect($restart, TQ_SIGNAL('clicked()'), TQ_SLOT('newGame()'));

    hits = TQt::LCDNumber(2, this, "hits");
    shotsLeft = TQt::LCDNumber(2, this, "shotsleft");
    my $hitsL = TQt::Label("HITS", this, "hitsLabel");
    my $shotsLeftL = TQt::Label("SHOTS LEFT", this, "shotsLeftLabel");

    my $accel = TQt::Accel(this);
    $accel->connectItem($accel->insertItem(TQt::KeySequence(int &Key_Enter)),
			this, TQ_SLOT('fire()'));
    $accel->connectItem($accel->insertItem(TQt::KeySequence(int &Key_Return)),
			this, TQ_SLOT('fire()'));
    $accel->connectItem($accel->insertItem(TQt::KeySequence(int &CTRL+&Key_Q)),
			TQt::app, TQ_SLOT('quit()'));

    my $grid = TQt::GridLayout(this, 2, 2, 10);
    $grid->addWidget($quit, 0, 0);
    $grid->addWidget($box, 1, 1);
    $grid->setColStretch(1, 10);

    my $leftBox = TQt::VBoxLayout;
    $grid->addLayout($leftBox, 1, 0);
    $leftBox->addWidget($angle);
    $leftBox->addWidget($force);

    my $topBox = TQt::HBoxLayout;
    $grid->addLayout($topBox, 0, 1);
    $topBox->addWidget($shoot);
    $topBox->addWidget(hits);
    $topBox->addWidget($hitsL);
    $topBox->addWidget(shotsLeft);
    $topBox->addWidget($shotsLeftL);
    $topBox->addStretch(1);
    $topBox->addWidget($restart);

    $angle->setValue(60);
    $force->setValue(25);
    $angle->setFocus();

    newGame();
}

sub fire {
    return if cannonField->gameOver or cannonField->isShooting;
    shotsLeft->display(int(shotsLeft->intValue - 1));
    cannonField->shoot;
}

sub hit {
    hits->display(int(hits->intValue + 1));
    if(shotsLeft->intValue == 0) {
	cannonField->setGameOver;
    } else {
	cannonField->newTarget;
    }
}

sub missed {
    cannonField->setGameOver if shotsLeft->intValue == 0;
}

sub newGame {
    shotsLeft->display(int(15));
    hits->display(0);
    cannonField->restartGame;
    cannonField->newTarget;
}

1;
