/***************************************************************************
 *
 * tdenetman-strongswan.cpp - A NetworkManager frontend for TDE
 *
 * Author: Thomas Kallenberg <tkallenb@hsr.ch>, <thomas@no-more-secrets.ch>
 *
 * Strongly based on the Code of Helmut Schaa <hschaa@suse.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <tdelocale.h>
#include <tqmessagebox.h>
#include <tqbutton.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <tqobjectlist.h>
#include <tqobject.h>
#include <tqcheckbox.h>
#include <kpassdlg.h>
#include <kgenericfactory.h>
#include <tqlabel.h>

#include "tdenetman-strongswan.h"

typedef KGenericFactory<StrongswanPlugin> StrongswanPluginFactory;
K_EXPORT_COMPONENT_FACTORY( tdenetman_strongswan, StrongswanPluginFactory("tdenetman_strongswan"));


StrongswanPlugin::StrongswanPlugin(TQObject* parent, const char* name, const TQStringList& args)
	: VPNPlugin(parent, name, args)
{
	TDELocale* loc = TDEGlobal::locale();
	loc->insertCatalogue("NetworkManager-strongswan");
}

StrongswanPlugin::~StrongswanPlugin()
{

}

VPNConfigWidget* StrongswanPlugin::CreateConfigWidget(TQWidget* parent)
{
	return new StrongswanConfig(parent);
}

VPNAuthenticationWidget* StrongswanPlugin::CreateAuthenticationWidget(TQWidget* parent)
{
	return new StrongswanAuthentication(parent);
}


StrongswanConfig::StrongswanConfig(TQWidget* parent)
	: VPNConfigWidget(parent)
{
	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_strongswanWidget = new StrongswanConfigWidget(this);
	layout->addWidget(_strongswanWidget);

	/* TODO not sure if we need this here */
	this->languageChange();
}

StrongswanConfig::~StrongswanConfig()
{

}

void StrongswanConfig::languageChange()
{

}

// usercert agent password userkey
StrongswanConnectionType::CONNECTIONTYPE StrongswanConnectionType::mapString2ConnectionType(int prop)
{
    if (prop == 0)
        return psk;
    else if (prop == 1)
        return key;
    else if (prop == 2)
        return agent;
    return UNKNOWN;
}

int StrongswanConnectionType::mapConnectionType2String(CONNECTIONTYPE connType)
{
    switch(connType)
    {
        case psk:
            return 0;
        case key:
            return 1;
        case agent:
            return 2;
        default:
            return -1;
    }
    return -1;
}

void StrongswanConfig::setVPNData(TDENetworkSingleRouteConfigurationList& routes, TDENetworkSettingsMap& properties, TDENetworkSettingsMap& secrets)
{
	m_vpnProperties = properties;
	m_vpnSecrets = secrets;

	// fill up our inputfields (only textfields atm)
	for(TDENetworkSettingsMap::iterator it = properties.begin(); it != properties.end(); ++it) {
		TQString entry = it.key();
		TQString value = it.data();

		if (entry == "gateway") {
			_strongswanWidget->gateway->setText(value);
		}
		else if (entry == "certificate") {
			_strongswanWidget->certificate->setURL(value);
		}
		else if (entry == "username") {
			_strongswanWidget->username->setText(value);
		}
		else if (entry == "method") {
			StrongswanConnectionType::CONNECTIONTYPE type = StrongswanConnectionType::mapString2ConnectionType(value.toInt());
			_strongswanWidget->authtype->setCurrentItem(type);
		}

		// Options
		else if (entry == "chkUDPenc") {
			_strongswanWidget->chkUDPenc->setChecked(value == "true");
		}
		else if (entry == "chkIPcomp") {
			_strongswanWidget->chkIPcomp->setChecked(value == "true");
		}
		else if (entry == "chkIPinner") {
			_strongswanWidget->chkIPinner->setChecked(value == "true");
		}
	}
}

TDENetworkSettingsMap StrongswanConfig::getVPNProperties()
{
	// Build a list of properties
	m_vpnProperties.insert("gateway", TQString(_strongswanWidget->gateway->text()));
	m_vpnProperties.insert("certificate", TQString(_strongswanWidget->certificate->url()));
	m_vpnProperties.insert("username", TQString(_strongswanWidget->username->text()));
	m_vpnProperties.insert("method", TQString::number(StrongswanConnectionType::mapConnectionType2String((StrongswanConnectionType::CONNECTIONTYPE)_strongswanWidget->authtype->currentItem())));

	if (_strongswanWidget->chkUDPenc->isChecked()) {
		m_vpnProperties.insert("encap", TQString("yes"));
	}
	else {
		m_vpnProperties.remove("encap");
	}

	if (_strongswanWidget->chkIPcomp->isChecked()) {
		m_vpnProperties.insert("ipcomp", TQString("yes"));
	}
	else {
		m_vpnProperties.remove("ipcomp");
	}

	if (_strongswanWidget->chkIPinner->isChecked()) {
		m_vpnProperties.insert("virtual", TQString("yes"));
	}
	else {
		m_vpnProperties.remove("virtual");
	}

	return m_vpnProperties;
}

TDENetworkSettingsMap StrongswanConfig::getVPNSecrets() {
	// Build a list of secrets
	// FIXME

	return m_vpnSecrets;
}

TDENetworkSingleRouteConfigurationList StrongswanConfig::getVPNRoutes()
{
	TDENetworkSingleRouteConfigurationList ret;
#if 0
	TQStringList strlist;
	if(_strongswanWidget->chkIPAdresses->isChecked()) {
		strlist = TQStringList::split(" ", _strongswanWidget->routes->text());
	}

	for (TQStringList::Iterator it = strlist.begin(); it != strlist.end(); ++it) {
		TQStringList pieces = TQStringList::split("/", (*it));
		TDENetworkSingleRouteConfiguration routeconfig;
		routeconfig.ipAddress.setAddress(pieces[0]);
		if (pieces.count() > 1) {
			routeconfig.networkMask.fromCIDRMask(pieces[1].toUInt());
		}
		ret.append(routeconfig);
	}
#endif

	return ret;

}

bool StrongswanConfig::hasChanged()
{
	return true;
}

bool StrongswanConfig::isValid(TQStringList& err_msg)
{
	bool retval = true;
	if(_strongswanWidget->gateway->text() == "" || _strongswanWidget->username->text() == "")
	{
		err_msg.append(i18n("At least the gateway and group has to be supplied."));
		retval = false;
	}
	return retval;
}

StrongswanAuthentication::StrongswanAuthentication(TQWidget* parent, char* name)
	: VPNAuthenticationWidget(parent, name)
{
	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_strongswanAuth = new StrongswanAuthenticationWidget(this);
	layout->addWidget(_strongswanAuth);
}

StrongswanAuthentication::~StrongswanAuthentication()
{

}

TDENetworkSettingsMap StrongswanAuthentication::getPasswords()
{
	TQMap<TQString, TQString> pwds;
	pwds.insert("user", TQString(_strongswanAuth->username->text()));
	pwds.insert("password", _strongswanAuth->password->password());
	return pwds;
}

void StrongswanAuthentication::setPasswords(TDENetworkSettingsMap secrets) {
	if (secrets.contains("password")) {
		_strongswanAuth->password->erase();
		_strongswanAuth->password->insert(secrets["password"]);
	}
}

#include "tdenetman-strongswan.moc"
