/***************************************************************************
 *   Copyright (C) 2006 by Marco Martin                                    *
 *   notmart@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the Lesser GNU General Public                   *
 *   License as published by the Free Software Foundation;                 *
 *   either version 2 of the License, or (at your option)                  *
 *   any later version.                                                    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TASTYLISTVIEW_H
#define TASTYLISTVIEW_H

#include <tdelistview.h>
#include <kiconloader.h>
#include <kservice.h>
#include <kservicegroup.h>
#include <kdesktopfile.h>
#include <tqpixmap.h>
#include <tqtooltip.h>
#include <tqtimer.h>
#include <tqheader.h>

class TastyListView;

//the space reserved for the action icon (bookmark, remove bookmark etc

/**
	@author Marco Martin <notmart@gmail.com>
 */
class TastyListViewToolTip: public TQToolTip
{
  public:
    TastyListViewToolTip( TQWidget *parent, TastyListView *tListView );

    void maybeTip( const TQPoint &pos );

  private:
    TastyListView *listView;
};

/**
	@author Marco Martin <notmart@gmail.com>
*/
class TastyListView : public TDEListView
{
    TQ_OBJECT
private:
    bool highLightGroups;
    TQTimer *onItemTimer;
    TQListViewItem *underCursorItem;
    TQListViewItem *openItem;
    bool mouseDown;
    bool easyOpen;
    int actionIconSize;
    int actionIconSpace;

    TastyListViewToolTip *listItemTip;

public:
    TastyListView( TQWidget * parent = 0, const char * name = 0);

    ~TastyListView();

    bool getHighLightGroups(){ return highLightGroups;}
    void setHighLightGroups(bool highLight){highLightGroups = highLight;}

    bool getEasyOpen(){ return easyOpen;}
    void setEasyOpen(bool easy){easyOpen = easy;}
    void startDrag();

    void setActionIconSize(int newSize){ actionIconSize = newSize; actionIconSpace = newSize*2; }
    int getActionIconSize(){return actionIconSize;}
    int getActionIconSpace(){return actionIconSpace;}

    TQListViewItem * getOpenItem(){ return openItem;}
    void setOpenItem( TQListViewItem * listItem ){openItem = listItem;}

public slots:
  virtual void clear(){openItem = underCursorItem = NULL; TDEListView::clear();}


protected:
    virtual void leaveEvent( TQEvent * e  );
    virtual void contentsMouseMoveEvent( TQMouseEvent * e  );
    virtual void contentsMouseReleaseEvent( TQMouseEvent * e  );
    virtual void keyPressEvent( TQKeyEvent * e );


private slots:
    void slotOnItem( TQListViewItem * listItem );
    void slotTimeout();

signals:
  //Using own signal instead of clicked() in order to avoid launching two times the same app :-)
    void activated(TQListViewItem *, const TQPoint &, int );

};


/**
	@author Marco Martin <notmart@gmail.com>
*/
class TastyListViewItem : public TDEListViewItem
{
    //TQ_OBJECT
friend class TastyListView;
 public:
    typedef enum
    {
     Service,
     ServiceGroup,
     DesktopFile,
     Empty
    }Type;

    typedef enum
    {
      AddBookMark,
      RemoveBookMark,
      OpenGroup,
      Expand,
      Collapse,
      NoAction
    }ActionType;

    TastyListViewItem( TastyListView * parent );
    TastyListViewItem( TastyListViewItem * parent );
    TastyListViewItem( TastyListView * parent, TastyListViewItem * after, TQString label1 );
    TastyListViewItem( TastyListViewItem * parent, TastyListViewItem * after, TQString label1 );
    TastyListViewItem( TastyListView * parent, TastyListViewItem * after );
    TastyListViewItem( TastyListViewItem * parent, TastyListViewItem * after );
    TastyListViewItem( TastyListView * parent, TQString label1 );
    TastyListViewItem( TastyListViewItem * parent, TQString label1 );

    ~TastyListViewItem();

    //TQString text(int column) const {return cellText;}
    TQString getCellText(int column) const {return cellText;}

    //TastyListViewItem *parent();
    void paintCell ( TQPainter * p, const TQColorGroup & cg, int column, int width, int align );

    Type getType(){return itemType;}
    void setType( Type newItemType ){itemType = newItemType;}

    ActionType getActionType(){return actionType;}
    void setActionType( ActionType newActionType ){ actionType = newActionType;loadPixmap();}
    void loadPixmap();

    void setPath( TQString newPath){ path = newPath;}
    TQString getPath(){return path;}

    void setDeskopEntryPath( TQString newPath){ desktopEntryPath = newPath;}
    TQString getDeskopEntryPath(){return desktopEntryPath;}

    TQString getSubText(){return subText;}
    bool xOnDecoration( int x )
       { TQListView *lv = listView();
         if( !lv ) return false;
         return !( x > lv->header()->sectionPos( lv->header()->mapToIndex( 0 ) ) +
                lv->treeStepSize() * ( depth() + ( lv->rootIsDecorated() ? 1 : 0) ) + lv->itemMargin() ||
                x < lv->header()->sectionPos( lv->header()->mapToIndex( 0 ) ) );}

    void setSubText(TQString text) //FIXME: add the column
       {if(cellText.isEmpty())cellText=TDEListViewItem::text(0);
        TDEListViewItem::setText(0,cellText+text);subText = TQString(text);}
    void setText(int column, const TQString & text )
       {TDEListViewItem::setText(column, cellText+text); cellText = text;}
    void setDisplaySubText( bool display ){ displaySubText = display; }

    bool hasEllipsis(){return ellipsis;}
    void setHighLight( bool newHighLight ){highLight=newHighLight;}
    bool isHighLight(){return highLight;}

    void setMenuId( TQString newMenuId ){ menuId = newMenuId;}
    TQString getMenuId(){ return menuId; }

    TQString key( int column, bool ascending ) const;

    int width( const TQFontMetrics & fm, const TQListView * lv, int c )
    {  TastyListView *tlv = dynamic_cast<TastyListView *>( listView() );
       if( tlv )
         return TDEListViewItem::width(fm, lv, c) + tlv->getActionIconSpace();
       else
         return TDEListViewItem::width(fm, lv, c);
    }

protected:
    virtual void setup();

private:

    Type itemType;
    ActionType actionType;
    TQString path;
    TQString desktopEntryPath;
    TQString cellText;
    TQString subText;
    TQString menuId;

    bool ellipsis;
    bool highLight;
    bool displaySubText;
    TQPixmap actionPix;
    TDEIconLoader *iconLoader;

    void commonConstructor();
    //a tiny reimplementation of max...
    int max(int a, int b){return (a>b?a:b);}
};


#endif
