/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "SetTriggerSegmentDefaultRetuneCommand.h"

#include <tdelocale.h>
#include "base/Composition.h"
#include "base/TriggerSegment.h"


namespace Rosegarden
{

SetTriggerSegmentDefaultRetuneCommand::SetTriggerSegmentDefaultRetuneCommand(Composition *composition,
        TriggerSegmentId id,
        bool newDefaultRetune) :
        KNamedCommand(i18n("Set Default Retune")),
        m_composition(composition),
        m_id(id),
        m_newDefaultRetune(newDefaultRetune),
        m_oldDefaultRetune(false),
        m_haveOldDefaultRetune(false)
{
    // nothing
}

SetTriggerSegmentDefaultRetuneCommand::~SetTriggerSegmentDefaultRetuneCommand()
{
    // nothing
}

void
SetTriggerSegmentDefaultRetuneCommand::execute()
{
    TriggerSegmentRec *rec = m_composition->getTriggerSegmentRec(m_id);
    if (!rec)
        return ;
    if (!m_haveOldDefaultRetune) {
        m_oldDefaultRetune = rec->getDefaultRetune();
    }
    rec->setDefaultRetune(m_newDefaultRetune);
}

void
SetTriggerSegmentDefaultRetuneCommand::unexecute()
{
    TriggerSegmentRec *rec = m_composition->getTriggerSegmentRec(m_id);
    if (!rec)
        return ;
    rec->setDefaultRetune(m_oldDefaultRetune);
}

}
