/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_SPLINE_H_
#define _RG_SPLINE_H_

#include "base/FastVector.h"


class TQPoint;
class PointList;


namespace Rosegarden
{



class Spline
{
public:
    typedef FastVector<TQPoint> PointList;

    /**
     * Calculate a set of polyline points to approximate
     * a Bezier spline.  Caller takes ownership of returned
     * heap-allocated container.
     */
    static PointList *calculate(const TQPoint &start, const TQPoint &finish,
                                const PointList &controlPoints,
                                TQPoint &topLeft, TQPoint &bottomRight);

private:
    static void calculateSegment
    (PointList *acc,
     const TQPoint &start, const TQPoint &finish, const TQPoint &control,
     TQPoint &topLeft, TQPoint &bottomRight);

    static void calculateSegmentSub
    (PointList *acc,
     const TQPoint &start, const TQPoint &finish, const TQPoint &control, int n,
     TQPoint &topLeft, TQPoint &bottomRight);
};



}

#endif
