/****************************************************************************

 KHotKeys
 
 Copyright (C) 1999-2001 Lubos Lunak <l.lunak@kde.org>

 Distributed under the terms of the GNU General Public License version 2.
 
****************************************************************************/

#ifndef _CONDITIONS_H_
#define _CONDITIONS_H_

#include <tqobject.h>
#include <tqptrlist.h>
#include <tqstring.h>

#include "khotkeysglobal.h"
#include "windows.h"

#include <X11/Xlib.h>
#include <fixx11h.h>

class TDEConfig;

namespace KHotKeys
{

class Action_data_base;
class Action_data;
class Condition_list_base;

class TDE_EXPORT Condition
    {
    public:
        Condition( Condition_list_base* parent_P );
        Condition( TDEConfig& cfg_P, Condition_list_base* parent_P );
        virtual ~Condition();
        virtual bool match() const = 0;
        virtual void updated() const; // called when the condition changes
        virtual void cfg_write( TDEConfig& cfg_P ) const = 0;
        virtual const TQString description() const = 0;
        virtual Condition* copy( Condition_list_base* parent_P ) const = 0;
        const Condition_list_base* parent() const;
        Condition_list_base* parent();
        static Condition* create_cfg_read( TDEConfig& cfg_P, Condition_list_base* parent_P );
    protected:
        Condition_list_base* const _parent;
    KHOTKEYS_DISABLE_COPY( Condition );
    };
        
class TDE_EXPORT Condition_list_base
    : public Condition, public TQPtrList< Condition > // inheritance ?
    {
    typedef Condition base;
    public:
        Condition_list_base( Condition_list_base* parent_P );
        Condition_list_base( const TQPtrList< Condition >& children_P,
            Condition_list_base* parent_P );
        Condition_list_base( TDEConfig& cfg_P, Condition_list_base* parent_P );
        virtual ~Condition_list_base();
        virtual void cfg_write( TDEConfig& cfg_P ) const;
        virtual bool accepts_children() const;
        typedef TQPtrListIterator< Condition > Iterator;
    };

class TDE_EXPORT Condition_list
    : public Condition_list_base
    {
    typedef Condition_list_base base;
    public:
        Condition_list( const TQString& comment_P, Action_data_base* data_P );
        Condition_list( TDEConfig& cfg_P, Action_data_base* data_P );
        void cfg_write( TDEConfig& cfg_P ) const;
        Condition_list* copy( Action_data_base* data_P ) const;
        virtual bool match() const;
        const TQString& comment() const;
        void set_data( Action_data_base* data_P );
        virtual void updated() const;
        virtual Condition_list* copy( Condition_list_base* parent_P ) const;
        virtual const TQString description() const;
    private:
        TQString _comment;
        Action_data_base* data;
    };

class TDE_EXPORT Active_window_condition
    : public TQObject, public Condition
    {
    TQ_OBJECT
    typedef Condition base;
    public:
        Active_window_condition( Windowdef_list* window_P, Condition_list_base* parent_P );
        Active_window_condition( TDEConfig& cfg_P, Condition_list_base* parent_P );
        virtual ~Active_window_condition();
        virtual bool match() const;
        virtual void cfg_write( TDEConfig& cfg_P ) const;
        const Windowdef_list* window() const;
#ifndef COVARIANT_RETURN_BROKEN
        virtual Active_window_condition* copy( Condition_list_base* parent_P ) const;
#else
        virtual Condition* copy( Condition_list_base* parent_P ) const;
#endif
        virtual const TQString description() const;
    public slots:
        void active_window_changed( WId );
    private:
        void init();
        void set_match();
        Windowdef_list* _window;
        bool is_match;
    };
            
class TDE_EXPORT Existing_window_condition
    : public TQObject, public Condition
    {
    TQ_OBJECT
    typedef Condition base;
    public:
        Existing_window_condition( Windowdef_list* window_P, Condition_list_base* parent_P );
        Existing_window_condition( TDEConfig& cfg_P, Condition_list_base* parent_P );
        virtual ~Existing_window_condition();
        virtual bool match() const;
        virtual void cfg_write( TDEConfig& cfg_P ) const;
        const Windowdef_list* window() const;
#ifndef COVARIANT_RETURN_BROKEN
        virtual Existing_window_condition* copy( Condition_list_base* parent_P ) const;
#else
        virtual Condition* copy( Condition_list_base* parent_P ) const;
#endif
        virtual const TQString description() const;
    public slots:
        void window_added( WId w_P );
        void window_removed( WId w_P );
    private:
        void init();
        void set_match( WId w_P = None );
        Windowdef_list* _window;
        bool is_match;
    };

class TDE_EXPORT Not_condition
    : public Condition_list_base
    {
    typedef Condition_list_base base;
    public:
        Not_condition( Condition_list_base* parent_P );
        Not_condition( TDEConfig& cfg_P, Condition_list_base* parent_P );
        virtual bool match() const;
        virtual void cfg_write( TDEConfig& cfg_P ) const;
        virtual Not_condition* copy( Condition_list_base* parent_P ) const;
        virtual const TQString description() const;
        const Condition* condition() const;
        virtual bool accepts_children() const;
    };
            
class TDE_EXPORT And_condition
    : public Condition_list_base
    {
    typedef Condition_list_base base;
    public:
        And_condition( Condition_list_base* parent_P );
        And_condition( TDEConfig& cfg_P, Condition_list_base* parent_P );
        virtual bool match() const;
        virtual void cfg_write( TDEConfig& cfg_P ) const;
        virtual And_condition* copy( Condition_list_base* parent_P ) const;
        virtual const TQString description() const;
    };
            
class TDE_EXPORT Or_condition
    : public Condition_list_base
    {
    typedef Condition_list_base base;
    public:
        Or_condition( Condition_list_base* parent_P );
        Or_condition( TDEConfig& cfg_P, Condition_list_base* parent_P );
        virtual bool match() const;
        virtual void cfg_write( TDEConfig& cfg_P ) const;
        virtual Or_condition* copy( Condition_list_base* parent_P ) const;
        virtual const TQString description() const;
    };
            
//***************************************************************************
// Inline
//***************************************************************************

// Condition

inline
const Condition_list_base* Condition::parent() const
    {
    return _parent;
    }
    
inline
Condition_list_base* Condition::parent()
    {
    return _parent;
    }
    
// Condition_list_base

inline
Condition_list_base::Condition_list_base( Condition_list_base* parent_P )
    : Condition( parent_P ), TQPtrList< Condition >()
    {
    }

inline
Condition_list_base::Condition_list_base( const TQPtrList< Condition >& children_P,
    Condition_list_base* parent_P )
    : Condition( parent_P ), TQPtrList< Condition >( children_P )
    {
    }

// Condition_list

inline
Condition_list::Condition_list( const TQString& comment_P, Action_data_base* data_P )
    : Condition_list_base( NULL ), _comment( comment_P ), data( data_P )
    {
    }

inline
const TQString& Condition_list::comment() const
    {
    return _comment;
    }

// Active_window_condition

inline
Active_window_condition::Active_window_condition( Windowdef_list* window_P,
    Condition_list_base* parent_P )
    : Condition( parent_P ), _window( window_P )
    {
    init();
    set_match();
    }
    
inline
const Windowdef_list* Active_window_condition::window() const
    {
    return _window;
    }

// Existing_window_condition

inline
Existing_window_condition::Existing_window_condition( Windowdef_list* window_P,
    Condition_list_base* parent_P )
    : Condition( parent_P ), _window( window_P ), is_match( false )
    {
    init();
    set_match();
    }
    
inline
const Windowdef_list* Existing_window_condition::window() const
    {
    return _window;
    }

// Not_condition

inline
Not_condition::Not_condition( Condition_list_base* parent_P )
    : Condition_list_base( parent_P )
    {
    }
    
inline
const Condition* Not_condition::condition() const
    {
    return getFirst();
    }

// And_condition

inline
And_condition::And_condition( Condition_list_base* parent_P )
    : Condition_list_base( parent_P )
    {
    }
    
// Or_condition

inline
Or_condition::Or_condition( Condition_list_base* parent_P )
    : Condition_list_base( parent_P )
    {
    }
    
} // namespace KHotKeys

#endif
