/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef __KVPNCCONFIG_H__
#define __KVPNCCONFIG_H__

//BEGIN INCLUDES
#include <tqobject.h>
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqapplication.h>
#include <tqcolor.h>
#include <tqpoint.h>
#include <tqsize.h>
#include <tqfile.h>
#include <tqtextstream.h>
#include <tqtextedit.h>
#include <tqcolor.h>
#include <tqstringlist.h>
#include <tdeconfig.h>
#include <tdewallet.h>
#include <kstatusbar.h>

#include "toolinfo.h"
#include "vpnaccountdata.h"

// ID for statusbar
#define ID_STATUS_MSG 1
#define ID_CONNECTION_MSG 2
#define ID_FLASH_MSG 3
//END INCLUDES

/**
This class holds global configuration data.
@author Christoph Thielecke <crissi99@gmx.de>
*/
class KVpncConfig : public TQObject
{
public:
	KVpncConfig(TQWidget *parent,KStatusBar *statusbar);
	~KVpncConfig();

public:
	enum ConnectionStatus {disconnected=0, connecting=1, connected=2};
	enum LogType {info=0, remote=1, error=2, success=3, debug=4};

	TQString pathToVpnc;
	TQString pathToCiscoVpnc;
	TQString pathToRacoon;
	TQString pathToRacoonctl;
	TQString pathToSetkey;
	TQString pathToIptables;
	TQString pathToOpenssl;
	TQString pathToIpsec;
	TQString pathToPppd;
	TQString pathToPptp;
	TQString pathToL2tpd;
	TQString pathToXl2tpd;
	TQString pathToOpenl2tp;
	TQString pathToKill;
	TQString pathToKillall;
	TQString pathToPing;
	TQString pathToOpenvpn;
	TQString pathToIp;
	TQString pathToIfconfig;
	TQString pathToRoute;
	TQString pathToNetstat;
	TQString pathToPkcs11Tool;
	TQString pathToVtund;
	TQString pathToCiscoCertMgr;
	TQString pathToTail;
	TQString pathToSsh;
	TQString pathToKsshAskpass;
	TQString pathToGnomeSshAskpass;
	TQString AutoConnectProfile;
	TQString RacoonDebugLevel;
	TQString Vpnc_pid_file;
	TQString Pppd_pid_file;
	TQString lastProfile;
	TQString logfileName;
	TQString InterpreterShell;

	TQString TmpPassword; //< from enter password dialog
	TQString TmpGroupPassword; //< from enter password dialog
	TQString TmpUsername; //< from enter password dialog
	TQString TmpPrivKeyPassStr;
	TQString TmpGatewayIP;
	TQString TmpXauthInterPasscode; //< from Xauth interactive passcode dialog
	TQString TmpPrivateKeyPass;
	TQString TmpHttpProxyPassword;
	TQString DnsDevice; //< device which the dns entry was added

	TQString OldDefaultGw; //< default gw before connect
	TQString OldDefaultDev; //< default gw dev before connect

	TQString NewDefaultGw;

	TQStringList PlutoDebug;
	TQStringList KlipsDebug;

	bool minimizeAfterConnect;
	bool showDebugConsole;
	bool writeLogFile;
	bool useDefaultPaths;
	bool useSilentQuit;
	bool holdGeneratedScripts;
	bool programsInPath;
	bool enableDebugPppd;
	bool enableDebugPptpd;
	bool enableDebugL2tpd;
	bool enableDebugXl2tpd;
	bool enableDebugOpenl2tp;

	bool enableDebugXl2tpdNetwork;
	bool enableDebugXl2tpdpacket;
	bool enableDebugXl2tpdstate;
	bool enableDebugXl2tpdtunnel;

	bool enableFreeswanVerbose;
	bool enableDebugOpenvpn;
	bool useColorizedLogOutput;
	bool showInterfaceIPinTooltip;
	bool dontQuitOnCloseEvent;
	bool doAutoConnectAtStartup;
	bool useTDEwallet;
	bool showStatusBar;
	bool showToolBar;
	bool hideMainWindow;
	bool PppdDebugLevel;
	bool firstUseOfTDEwallet; //< for importing passwords if there are stored before
	bool shutdownIsCalled;
	bool haveUserData; //< flag if user data already collected, set after data is entered and unset if authretry
	bool skipTDEwalletStoring; //< true if save should skip saving into tdewallet
	bool hideOnCloseInfo;
	bool feedbackMailSent;
	bool doKillL2tpdIfStillRunning; //< kill l2tpd if its still running and not started from kvpnc
	bool doKillXl2tpdIfStillRunning; //< kill xl2tpd if its still running and not started from kvpnc
	bool doKillRacoonIfStillRunning; //< kill racoon if its still running and not started from kvpnc
	bool showConnectionTimeInTooltip; //< True if the connection duration should be shown in kicker tooltip
	bool WaitingForXauth; //< if waiting for xauth is set to true, needed to detect wrong xautn data on strongswan
	bool prefDlgOpen; //< if true prefDlgOpen is open

	bool OpenvpnNeedSecurityParameter;

	int VpncDebugLevel;
	int KvpncDebugLevel;
	int OpenvpnDebugLevel;
	int PptpLogLevel;
	int PppdKernelLogLevel;
	int SshDebugLevel;
	int LogViewerFontSize;
	int mainwindow_pos_x;
	int mainwindow_pos_y;
	int mainwindow_height;
	int mainwindow_width;
	int connectSleepDelay; //< time beetween retry
	int connectSleepRetry; //< count of retries
	int tryConnectTimeout; //< timeout in at connecting
	int connectionStartTime;
	int runningCheckCounter;
	int runningCheckTimeout;
	int OpenvpnManagementPort;
	int AuthRetryCount; //< count of autn retry
	int maxConnectRetry; // max connect tries
	int currentConnectRetry;

	TQPtrList<ToolInfo> *ToolList;
	TQPtrList<VpnAccountData> *AccountList;
	VpnAccountData *currentProfile;

	TQColor InfoLogColor;
	TQColor RemoteLogColor;
	TQColor ErrorLogColor;
	TQColor SuccessLogColor;
	TQColor DebugLogColor;
	TQColor DebugBackgroundcolor;

	TQApplication *appPointer;
	TQPoint pos;
	ConnectionStatus status;
	TQFile logfile;
	TQTextStream logFileStream;
	TQTextEdit *LogOutput;
	TDEWallet::Wallet *wallet;
	TDEConfig* config; //< configuration data

	TQPoint WindowPos;
	TQSize WindowSize;

	struct IpsecImportSection {
		TQString SectionName;
		TQStringList SectionData;
	};
	
	TQPtrList<VpnAccountData> *ImportedAccountList;

	TQWidget *parent;
	KStatusBar *statusbar;

	/**
	 * Appends a log enty to debug console and log file
	 * @param msg the text to append
	 * @param type the type of the msg (info, debug, error, etc)
	 */
	void appendLogEntry( TQString msg, LogType type );

	/**
	 *  Sets the output textedit for debug output
	 * @param LogOutput
	 */
	void setLogOutput(TQTextEdit *LogOutput);

	/**
	* save configuration
	*/
	void saveOptions(bool saveOneProfile=false, TQString Profile="" );

	/**
	* load configuration
	*/
	void loadOptions();
	
	/**
	* check the value of the paths
	*/
	void checkStandardPathValues();

	/**
	 *  collects the information of the external helper programs
	 */
	void getToolsInfo();


	/**
	 *  removes a entry from configuration file
	 * @param Name the entry which should be removed
	 */
	void removeEntry(TQString Name);

	VpnAccountData* findProfile(TQPtrList<VpnAccountData> *list,const TQString& Name);
	TQString removeWhiteSpaceAtBegin(const TQString);

	void slotStatusMsg( const TQString &text, int id = ID_STATUS_MSG );
	void doBackupConfig();
	void restoreBackupConfig();

	bool exportKvpncConfig(TQString filename);
	bool importKvpncConfig(TQString filename, TQString& Name, bool& openProfileManager); //< true if profiles imported

	bool importIpsecConfig(TQString filename, TQString& Name, bool& openProfileManager);
	bool importFritzboxConfig(TQString filename, TQString& Name, bool& openProfileManager);

};

#endif
