/****************************************************************************
** $Id$
**
** Copyright ( C ) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
import org.trinitydesktop.qt.*;
import java.util.*;

public class ABCentralWidget extends TQWidget
{
    protected TQGridLayout mainGrid;
    protected TQTabWidget tabWidget;
    protected TQListView listView;
    protected TQPushButton add, change, find;
    protected TQLineEdit iFirstName, iLastName, iAddress, iEMail,
        sFirstName, sLastName, sAddress, sEMail;
    protected TQCheckBox cFirstName, cLastName, cAddress, cEMail;


public ABCentralWidget( TQWidget parent, String name )
{
    super( parent, name );
    mainGrid = new TQGridLayout( this, 2, 1, 5, 5 );

    setupTabWidget();
    setupListView();

    mainGrid.setRowStretch( 0, 0 );
    mainGrid.setRowStretch( 1, 1 );
}

public ABCentralWidget( TQWidget parent )
{
	this(parent, null);
}

public void save( String filename )
{
    if ( listView.firstChild() == null )
        return;

    TQFile f = new TQFile( filename );
    if ( !f.open( TQIODevice.IO_WriteOnly ) )
        return;

    TQTextStream t = new TQTextStream( f );

    Iterator it = listView.itemList().iterator();
	while ( it.hasNext() ) {
		TQListViewItem currentItem = (TQListViewItem) it.next();
        for ( int i = 0; i < 4; i++ ) {
			t.writeRawBytes( currentItem.text(i), currentItem.text(i).length() );
			t.writeRawBytes( "\n", 1 );
		}
	}
    
	f.close();
}

public void load( String filename )
{
    listView.clear();

    TQFile f = new TQFile( filename );
    if ( !f.open( TQIODevice.IO_ReadOnly ) )
        return;

    TQTextStream t = new TQTextStream( f );

    while ( !t.atEnd() ) {
        TQListViewItem item = new TQListViewItem( listView );
        for ( int i = 0; i < 4; i++ )
            item.setText( i, t.readLine() );
    }

    f.close();
}

public void setupTabWidget()
{
    tabWidget = new TQTabWidget( this );

    TQWidget input = new TQWidget( tabWidget );
    TQGridLayout grid1 = new TQGridLayout( input, 2, 5, 5, 5 );

    TQLabel liFirstName = new TQLabel( "First &Name", input );
    liFirstName.resize( liFirstName.sizeHint() );
    grid1.addWidget( liFirstName, 0, 0 );

    TQLabel liLastName = new TQLabel( "&Last Name", input );
    liLastName.resize( liLastName.sizeHint() );
    grid1.addWidget( liLastName, 0, 1 );

    TQLabel liAddress = new TQLabel( "Add&ress", input );
    liAddress.resize( liAddress.sizeHint() );
    grid1.addWidget( liAddress, 0, 2 );

    TQLabel liEMail = new TQLabel( "&E-Mail", input );
    liEMail.resize( liEMail.sizeHint() );
    grid1.addWidget( liEMail, 0, 3 );

    add = new TQPushButton( "A&dd", input );
    add.resize( add.sizeHint() );
    grid1.addWidget( add, 0, 4 );
    connect( add, TQ_SIGNAL( "clicked()" ), this, TQ_SLOT( "addEntry()" ) );

    iFirstName = new TQLineEdit( input );
    iFirstName.resize( iFirstName.sizeHint() );
    grid1.addWidget( iFirstName, 1, 0 );
    liFirstName.setBuddy( iFirstName );

    iLastName = new TQLineEdit( input );
    iLastName.resize( iLastName.sizeHint() );
    grid1.addWidget( iLastName, 1, 1 );
    liLastName.setBuddy( iLastName );

    iAddress = new TQLineEdit( input );
    iAddress.resize( iAddress.sizeHint() );
    grid1.addWidget( iAddress, 1, 2 );
    liAddress.setBuddy( iAddress );

    iEMail = new TQLineEdit( input );
    iEMail.resize( iEMail.sizeHint() );
    grid1.addWidget( iEMail, 1, 3 );
    liEMail.setBuddy( iEMail );

    change = new TQPushButton( "&Change", input );
    change.resize( change.sizeHint() );
    grid1.addWidget( change, 1, 4 );
    connect( change, TQ_SIGNAL( "clicked()" ), this, TQ_SLOT( "changeEntry()" ) );

    tabWidget.addTab( input, "&Add/Change Entry" );

    // --------------------------------------

    TQWidget search = new TQWidget( this );
    TQGridLayout grid2 = new TQGridLayout( search, 2, 5, 5, 5 );

    cFirstName = new TQCheckBox( "First &Name", search );
    cFirstName.resize( cFirstName.sizeHint() );
    grid2.addWidget( cFirstName, 0, 0 );
    connect( cFirstName, TQ_SIGNAL( "clicked()" ), this, TQ_SLOT( "toggleFirstName()" ) );

    cLastName = new TQCheckBox( "&Last Name", search );
    cLastName.resize( cLastName.sizeHint() );
    grid2.addWidget( cLastName, 0, 1 );
    connect( cLastName, TQ_SIGNAL( "clicked()" ), this, TQ_SLOT( "toggleLastName()" ) );

    cAddress = new TQCheckBox( "Add&ress", search );
    cAddress.resize( cAddress.sizeHint() );
    grid2.addWidget( cAddress, 0, 2 );
    connect( cAddress, TQ_SIGNAL( "clicked()" ), this, TQ_SLOT( "toggleAddress()" ) );

    cEMail = new TQCheckBox( "&E-Mail", search );
    cEMail.resize( cEMail.sizeHint() );
    grid2.addWidget( cEMail, 0, 3 );
    connect( cEMail, TQ_SIGNAL( "clicked()" ), this, TQ_SLOT( "toggleEMail()" ) );

    sFirstName = new TQLineEdit( search );
    sFirstName.resize( sFirstName.sizeHint() );
    grid2.addWidget( sFirstName, 1, 0 );

    sLastName = new TQLineEdit( search );
    sLastName.resize( sLastName.sizeHint() );
    grid2.addWidget( sLastName, 1, 1 );

    sAddress = new TQLineEdit( search );
    sAddress.resize( sAddress.sizeHint() );
    grid2.addWidget( sAddress, 1, 2 );

    sEMail = new TQLineEdit( search );
    sEMail.resize( sEMail.sizeHint() );
    grid2.addWidget( sEMail, 1, 3 );

    find = new TQPushButton( "F&ind", search );
    find.resize( find.sizeHint() );
    grid2.addWidget( find, 1, 4 );
    connect( find, TQ_SIGNAL( "clicked()" ), this, TQ_SLOT( "findEntries()" ) );

    cFirstName.setChecked( true );
    sFirstName.setEnabled( true );
    sLastName.setEnabled( false );
    sAddress.setEnabled( false );
    sEMail.setEnabled( false );

    tabWidget.addTab( search, "&Search" );

    mainGrid.addWidget( tabWidget, 0, 0 );
}

public void setupListView()
{
    listView = new TQListView( this );
    listView.addColumn( "First Name" );
    listView.addColumn( "Last Name" );
    listView.addColumn( "Address" );
    listView.addColumn( "E-Mail" );

    listView.setSelectionMode( TQListView.Extended );

    connect( listView, TQ_SIGNAL( "clicked( TQListViewItem )" ), this, TQ_SLOT( "itemSelected( TQListViewItem )" ) );

    mainGrid.addWidget( listView, 1, 0 );
    listView.setAllColumnsShowFocus( true );
}

public void addEntry()
{
    if ( !iFirstName.text().equals("") || !iLastName.text().equals("") ||
         !iAddress.text().equals("") || !iEMail.text().equals("") ) {
        TQListViewItem item = new TQListViewItem( listView );
        item.setText( 0, iFirstName.text() );
        item.setText( 1, iLastName.text() );
        item.setText( 2, iAddress.text() );
        item.setText( 3, iEMail.text() );
    }

    iFirstName.setText( "" );
    iLastName.setText( "" );
    iAddress.setText( "" );
    iEMail.setText( "" );
}

public void changeEntry()
{
    TQListViewItem item = listView.currentItem();

    if ( item != null &&
         ( !iFirstName.text().equals("") || !iLastName.text().equals("") ||
         !iAddress.text().equals("") || !iEMail.text().equals("") ) ) {
        item.setText( 0, iFirstName.text() );
        item.setText( 1, iLastName.text() );
        item.setText( 2, iAddress.text() );
        item.setText( 3, iEMail.text() );
    }
}

public void selectionChanged()
{
    iFirstName.setText( "" );
    iLastName.setText( "" );
    iAddress.setText( "" );
    iEMail.setText( "" );
}

public void itemSelected( TQListViewItem item )
{
    item.setSelected( true );
    item.repaint();

    iFirstName.setText( item.text( 0 ) );
    iLastName.setText( item.text( 1 ) );
    iAddress.setText( item.text( 2 ) );
    iEMail.setText( item.text( 3 ) );
}

public void toggleFirstName()
{
    sFirstName.setText( "" );

    if ( cFirstName.isChecked() ) {
        sFirstName.setEnabled( true );
        sFirstName.setFocus();
    }
    else
        sFirstName.setEnabled( false );
}

public void toggleLastName()
{
    sLastName.setText( "" );

    if ( cLastName.isChecked() ) {
        sLastName.setEnabled( true );
        sLastName.setFocus();
    }
    else
        sLastName.setEnabled( false );
}

public void toggleAddress()
{
    sAddress.setText( "" );

    if ( cAddress.isChecked() ) {
        sAddress.setEnabled( true );
        sAddress.setFocus();
    }
    else
        sAddress.setEnabled( false );
}

public void toggleEMail()
{
    sEMail.setText( "" );

    if ( cEMail.isChecked() ) {
        sEMail.setEnabled( true );
        sEMail.setFocus();
    }
    else
        sEMail.setEnabled( false );
}

public void findEntries()
{
    if ( !cFirstName.isChecked() &&
         !cLastName.isChecked() &&
         !cAddress.isChecked() &&
         !cEMail.isChecked() ) {
        listView.clearSelection();
        return;
    }
    
	Iterator it = listView.itemList().iterator();
	while ( it.hasNext() ) {
		TQListViewItem currentItem = (TQListViewItem) it.next();
        boolean select = true;

        if ( cFirstName.isChecked() ) {
            if ( select && currentItem.text( 0 ).indexOf( sFirstName.text() ) != -1 )
                select = true;
            else
                select = false;
        }
        if ( cLastName.isChecked() ) {
            if ( select && currentItem.text( 1 ).indexOf( sLastName.text() ) != -1 )
                select = true;
            else
                select = false;
        }
        if ( cAddress.isChecked() ) {
            if ( select && currentItem.text( 2 ).indexOf( sAddress.text() ) != -1 )
                select = true;
            else
                select = false;
        }
        if ( cEMail.isChecked() ) {
            if ( select && currentItem.text( 3 ).indexOf( sEMail.text() ) != -1 )
                select = true;
            else
                select = false;
        }

        if ( select )
            currentItem.setSelected( true );
        else
           currentItem.setSelected( false );
       currentItem.repaint();
    }
}

}
