/****************************************************************************
** $Id$
**
** Copyright ( C ) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
import org.trinitydesktop.qt.*;

class ABMainWindow extends TQMainWindow
{
    protected TQToolBar fileTools;
    protected String filename;
    protected ABCentralWidget view;

public ABMainWindow()
{
    super( null, "example addressbook application" );
    filename = "";
    setupMenuBar();
    setupFileTools();
    setupStatusBar();
    setupCentralWidget();
}

public void setupMenuBar()
{
    TQPopupMenu file = new TQPopupMenu( this );
    menuBar().insertItem( "&File", file );

    file.insertItem( "New", this, TQ_SLOT( "fileNew()" ), new TQKeySequence(CTRL + Key_N) );
    file.insertItem( new TQIconSet(new TQPixmap( "fileopen.xpm" )), "Open", this, TQ_SLOT( "fileOpen()" ), new TQKeySequence(CTRL + Key_O) );
    file.insertSeparator();
    file.insertItem( new TQIconSet(new TQPixmap( "filesave.xpm" )), "Save", this, TQ_SLOT( "fileSave()" ), new TQKeySequence(CTRL + Key_S) );
    file.insertItem( "Save As...", this, TQ_SLOT( "fileSaveAs()" ) );
    file.insertSeparator();
    file.insertItem( new TQIconSet(new TQPixmap( "fileprint.xpm" )), "Print...", this, TQ_SLOT( "filePrint()" ), new TQKeySequence(CTRL + Key_P) );
    file.insertSeparator();
    file.insertItem( "Close", this, TQ_SLOT( "closeWindow()" ), new TQKeySequence(CTRL + Key_W) );
    file.insertItem( "Quit", tqApp(), TQ_SLOT( "quit()" ), new TQKeySequence(CTRL + Key_Q) );
}

public void setupFileTools()
{
    //fileTools = new TQToolBar( this, "file operations" );
}

public void setupStatusBar()
{
    //statusBar()->message( "Ready", 2000 );
}

public void setupCentralWidget()
{
    view = new ABCentralWidget( this );
    setCentralWidget( view );
}

public void closeWindow()
{
    close();
}

public void fileNew()
{
}

public void fileOpen()
{
    String fn = TQFileDialog.getOpenFileName( "", "", this );
    if ( !fn.equals("") ) {
        filename = fn;
        view.load( filename );
    }
}

public void fileSave()
{
    if ( filename.equals("") ) {
        fileSaveAs();
        return;
    }

    view.save( filename );
}

public void fileSaveAs()
{
    String fn = TQFileDialog.getSaveFileName( "", "", this );
    if ( !fn.equals("") ) {
        filename = fn;
        fileSave();
    }
}

public void filePrint()
{
}

}
