/***************************************************************************
 * $Id: tork.cpp,v 1.160 2007/12/30 12:58:22 hoganrobert Exp $
 *   Copyright (C) 2006 by Robert Hogan                                    *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

#include <stdlib.h>

#include <tqcstring.h>
#include <kdebug.h>
#include <tdeinstance.h>
#include <kurl.h>

#include "appinfo.h"

using namespace TDEIO;

extern "C"
{
  int kdemain(int argc, char **argv)
  {
    kdDebug(7129) << "*** Starting tdeio_appinfo " << endl;

    if (argc != 4)
    {
      kdDebug(7129) << "Usage: tdeio_appinfo protocol domain-socket1 domain-socket2" << endl;
      exit(255);
    }

    TDEInstance instance("tdeio_appinfo");
    TDEIO_AppInfo slave(argv[2], argv[3]);
    slave.dispatchLoop();
    return 0;
  }
}


TDEIO_AppInfo::TDEIO_AppInfo(const TQCString &pool_socket, const TQCString &app_socket)
	    : SlaveBase("tdeio_appinfo", pool_socket, app_socket), m_impl(this)
{
  kdDebug(7129) << "TDEIO_AppInfo::TDEIO_AppInfo()" << endl;
}


TDEIO_AppInfo::~TDEIO_AppInfo()
{
  kdDebug(7129) << "TDEIO_AppInfo::~TDEIO_AppInfo()" << endl;
}


void TDEIO_AppInfo::stat(const KURL &url)
{
  kdDebug(7129) << "TDEIO_AppInfo::stat: " << url << endl;

  TQString path = url.path();
  if (path.isEmpty() || path == "/")
  {
    kdDebug(7129) << "TDEIO_AppInfo::stat: " << "creating top level entry" << endl;
    // The root is "virtual" - it's not a single physical directory
    TDEIO::UDSEntry entry;
    m_impl.createTopLevelEntry(entry);
    statEntry(entry);
    finished();
    return;
  }

  TQString name;
  bool ok = m_impl.parseURL(url, name, path);
  if (!ok)
  {
    kdDebug(7129) << "TDEIO_AppInfo::stat: " << "can't parse url" << endl;
    error(TDEIO::ERR_MALFORMED_URL, url.prettyURL());
    return;
  }

  if (path.isEmpty())
  {
    kdDebug(7129) << "TDEIO_AppInfo::stat: " << "url empty after parsing" << endl;

    TDEIO::UDSEntry entry;
    if (m_impl.statByName(name, entry))
    {
      statEntry(entry);
      finished();
    }
    else
    {
      error(TDEIO::ERR_DOES_NOT_EXIST, url.prettyURL());
    }
  }
  else
  {
    kdDebug(7129) << "TDEIO_AppInfo::stat: " << "url not empty after parsing: statting" << endl;
    SlaveBase::stat(url);
  }
}

void TDEIO_AppInfo::listDir(const KURL &url)
{
  kdDebug(7129) << "TDEIO_AppInfo::listDir: " << url << endl;

  if (url.path().length() <= 1)
  {
    kdDebug(7129) << "TDEIO_AppInfo::listDir: " << "url empty: listing root" << endl;
    listRoot();
    return;
  }

  TQString name, path;
  bool ok = m_impl.parseURL(url, name, path);
  if (!ok)
  {
    error(TDEIO::ERR_MALFORMED_URL, url.prettyURL());
    return;
  }

  kdDebug(7129) << "TDEIO_AppInfo::listDir: " << "name is " << name << endl;
  kdDebug(7129) << "TDEIO_AppInfo::listDir: " << "path is " << path << endl;

  // We've been given something like appinfo:/name
  listAppContents(name);
}

void TDEIO_AppInfo::listRoot()
{
  m_impl.listRoot();
}

void TDEIO_AppInfo::listAppContents(const TQString &name)
{
  TDEIO::UDSEntryList app_entries;
  bool ok = m_impl.listAppContents(name, app_entries);
  if (!ok)
  {
    error(m_impl.lastErrorCode(), m_impl.lastErrorMessage());
    return;
  }

  totalSize(app_entries.count() + 1);

  TDEIO::UDSEntry entry;
  m_impl.createTopLevelEntry(entry);
  listEntry(entry, false);
  listEntries(app_entries);
  finished();
}
