/***************************************************************************
                             ksettingsregister.cpp
                             --------------------
    copyright            : (C) 2005 by Thomas Baumgart
    email                : ipwizard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// TQt Includes

// ----------------------------------------------------------------------------
// TDE Includes

#include <ktextedit.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "ksettingsregister.h"
#include <kmymoney/transactionsortoption.h>

KSettingsRegister::KSettingsRegister(TQWidget* parent, const char* name) :
  KSettingsRegisterDecl(parent, name)
{
  // hide the internally used text fields
  kcfg_sortNormalView->hide();
  kcfg_sortReconcileView->hide();
  kcfg_sortSearchView->hide();

  // setup connections, so that the sort optios get loaded once the edit fields are filled
  connect(kcfg_sortNormalView, TQ_SIGNAL(textChanged()), this, TQ_SLOT(slotLoadNormal()));
  connect(kcfg_sortReconcileView, TQ_SIGNAL(textChanged()), this, TQ_SLOT(slotLoadReconcile()));
  connect(kcfg_sortSearchView, TQ_SIGNAL(textChanged()), this, TQ_SLOT(slotLoadSearch()));

  // setup connections, so that changes by the user are forwarded to the (hidden) edit fields
  connect(m_sortNormalView, TQ_SIGNAL(settingsChanged(const TQString&)), kcfg_sortNormalView, TQ_SLOT(setText(const TQString&)));
  connect(m_sortReconcileView, TQ_SIGNAL(settingsChanged(const TQString&)), kcfg_sortReconcileView, TQ_SLOT(setText(const TQString&)));
  connect(m_sortSearchView, TQ_SIGNAL(settingsChanged(const TQString&)), kcfg_sortSearchView, TQ_SLOT(setText(const TQString&)));
}

KSettingsRegister::~KSettingsRegister()
{
}

void KSettingsRegister::slotLoadNormal(void)
{
  // only need this once
  disconnect(kcfg_sortNormalView, TQ_SIGNAL(textChanged()), this, TQ_SLOT(slotLoadNormal()));
  m_sortNormalView->setSettings(kcfg_sortNormalView->text());
}

void KSettingsRegister::slotLoadReconcile(void)
{
  // only need this once
  disconnect(kcfg_sortReconcileView, TQ_SIGNAL(textChanged()), this, TQ_SLOT(slotLoadReconcile()));
  m_sortReconcileView->setSettings(kcfg_sortReconcileView->text());
}

void KSettingsRegister::slotLoadSearch(void)
{
  // only need this once
  disconnect(kcfg_sortSearchView, TQ_SIGNAL(textChanged()), this, TQ_SLOT(slotLoadSearch()));
  m_sortSearchView->setSettings(kcfg_sortSearchView->text());
}

#include "ksettingsregister.moc"
