/***************************************************************************
                          kmymoneytitlelabel.cpp
                             -------------------
    begin                : Sun Feb 05 2005
    copyright            : (C) 2005 by Ace Jones
    email                : acejones@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqpixmap.h>
#include <tqvariant.h>
#include <tqstyle.h>
#include <tqpainter.h>

// ----------------------------------------------------------------------------
// TDE Includes

#include <tdeglobal.h>
#include <kstandarddirs.h>
#include <kdebug.h>
#include <tdeglobalsettings.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "kmymoneytitlelabel.h"

KMyMoneyTitleLabel::KMyMoneyTitleLabel(TQWidget *parent, const char *name) :
  TQLabel(parent, name),
  m_bgColor( TDEGlobalSettings::highlightColor() ),
  m_textColor( TDEGlobalSettings::highlightedTextColor() )
{
  setFont(TDEGlobalSettings::windowTitleFont());
}

KMyMoneyTitleLabel::~KMyMoneyTitleLabel()
{
}

void KMyMoneyTitleLabel::setLeftImageFile(const TQString& _file)
{
  m_leftImageFile = _file;
  TQString lfullpath = TDEGlobal::dirs()->findResource("appdata", m_leftImageFile);
  m_leftImage.load(lfullpath);
  m_leftImage.setAlphaBuffer(true);
}

void KMyMoneyTitleLabel::setRightImageFile(const TQString& _file)
{
  m_rightImageFile = _file;
  TQString rfullpath = TDEGlobal::dirs()->findResource("appdata", m_rightImageFile);
  m_rightImage.load(rfullpath);
  m_rightImage.setAlphaBuffer(true);
  if(m_rightImage.height() < 30)
    setMinimumHeight(30);
  else {
    setMinimumHeight( m_rightImage.height() );
    setMaximumHeight( m_rightImage.height() );
  }
}

void KMyMoneyTitleLabel::resizeEvent ( TQResizeEvent * )
{
  TQRect cr = contentsRect();
  TQImage output( cr.width(), cr.height(), 32 );
  output.fill( m_bgColor.rgb() );

  bitBlt ( &output, cr.width() - m_rightImage.width(), 0, &m_rightImage, 0, 0, m_rightImage.width(), m_rightImage.height(), 0 );
  bitBlt ( &output, 0, 0, &m_leftImage, 0, 0, m_leftImage.width(), m_leftImage.height(), 0 );

  TQPixmap pix;
  pix.convertFromImage(output);
  setPixmap(pix);
  setMinimumWidth( m_rightImage.width() );
}

void KMyMoneyTitleLabel::drawContents(TQPainter *p)
{
  // first draw pixmap
  TQLabel::drawContents(p);

  // then draw text on top
  style().drawItem( p, contentsRect(), alignment(), colorGroup(), isEnabled(),
                          0, TQString("   ")+m_text, -1, &m_textColor );
}

void KMyMoneyTitleLabel::setText(const TQString& txt)
{
  m_text = txt;
  update();
}

#include "kmymoneytitlelabel.moc"
