/***************************************************************************
                          knutmessage.h  -  description
                             -------------------
    begin                : So led 24 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTMESSAGE_H
#define KNUTMESSAGE_H

#include <kdialogbase.h>

//#include <tqpixmap.h>
//#include <tqtimer.h>


/**
  *@author Daniel Prynych
  */


class TQTimer;
class TQPixmap;

/**
 * Tato trida zobrazi okno zpravy v modeless rezimu.
 * Okno pracuje nezavisle na ostatnich oknech a NEPOZASTAVUJE jejich cinnost.
 *
 * @author Daniel Prynych
 * @short window message
 * @version 0.1
  */
class KNutMessage : public KDialogBase  {
    TQ_OBJECT
  
public: 

enum typeOfMessage {
  infoMess,
  warningMess,
  criticalMess
  };


/**
 * Constructor - makes window of message.
 * Konstruktor - vytvori okno zpravy.
 * @param  messageText  is text of message 
 * @param  type is type of message see on enum typeOfMessage
 * @param  timeValidity maximal time for showing window, if it is equal zere, time is unlimited.
 *
 * @param  messageText je text zpravu.
 * @param  type je typ zpravy blize enum typeOfMessage
 * @param  timeValidity maximalni doba zobrazeni okna, je-li rovna nule je neomezena.
 * @since  0.2
 */
  KNutMessage(const TQString messageText, const typeOfMessage type=infoMess, const long int timeValidity=0, TQWidget *parent=0, const char *name=0);

/**
 * Destruktor.
 *
 * @since  0.1.2
 **/
  ~KNutMessage();

signals:
/**
 * Je emitovan kdyz dojde ke stisku tlacitka OK, nebo vyprsi doba platnosti (timeValidity).
 * Is emited, when button OK is pressed or time of validity is stopped.
 *
 * @since  0.1
 **/
  void endMessage(void);

/**
 * Is emited when window of message is moved;
 * Je emitovan kdyz dojde presunu okna.
 *
 * @since  0.1
 **/

  void messageMoved (int, int);

private slots:

/**
 * @internal
 * Je aktivivan, kdyz vyprsi doba platnosti (timeValidity).
 *
 * @since  0.1
 **/
  void timeout(void);

/**
 * @internal
 * Is activated when button OK was pressed
 * Je aktivovan kdyz se stiskne tlacitko OK
 *
 * @since  0.1
 **/
  virtual void slotOk (void);


private:
  // max rime for message window is 3600 sec or 60 min
  static const int maxTime = 3600;

  TQPixmap m_ret;
  TQTimer* m_messageTimer;

protected:
  void moveEvent ( TQMoveEvent * e);


};

#endif
