/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

// TDE
#include <tdeapplication.h>

// Portal
#include "email_portal.h"
#include "email_portal.moc"

TDEEmailPortal::TDEEmailPortal(TQT_DBusConnection &connection)
: m_connection(connection)
{
}

TDEEmailPortal::~TDEEmailPortal()
{
}

void TDEEmailPortal::handleMethodReply(const TQT_DBusMessage &reply)
{
    m_connection.send(reply);
}

bool TDEEmailPortal::handleSignalSend(const TQT_DBusMessage& reply) {
    handleMethodReply(reply);
    return true;
}

bool TDEEmailPortal::ComposeEmail(const TQT_DBusObjectPath& handle,
                                  const TQString& app_id,
                                  const TQString& parent_window,
                                  const TQT_DBusVariantMap& options,
                                  TQ_UINT32& response,
                                  TQT_DBusVariantMap &results,
                                  TQT_DBusError& error)
{
    EmailOpts opts;
    if (OPTION_VALID("address", "s"))
        opts.rcpt << options["address"].value.toString();

    if (OPTION_VALID("addresses", "as"))
        opts.rcpt += options["addresses"].value.toList().toTQStringList();

    if (OPTION_VALID("cc", "as"))
        opts.cc += options["cc"].value.toList().toTQStringList();

    if (OPTION_VALID("bcc", "as"))
        opts.bcc += options["bcc"].value.toList().toTQStringList();

    if (OPTION_VALID("subject", "s"))
        opts.subj = options["subject"].value.toString();

    if (OPTION_VALID("body", "s"))
        opts.body = options["body"].value.toString();

    if (OPTION_VALID("attachments", "as"))
    {
        opts.attach += options["attachments"].value.toList().toTQStringList();
    }

    kapp->invokeMailer(opts.rcpt.join(";"), opts.cc.join(";"), opts.bcc.join(";"),
                       opts.subj, opts.body, TQString::null, opts.attach);
    return true;
}

// kate: replace-tabs true; tab-width 4; indent-width 4;