/***************************************************************************
 *   Copyright (C) 2006 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tqstringlist.h>
#include <tqdir.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqtextstream.h>
#include <ktempdir.h>

#include "basketthumbcreator.h"

bool BasketThumbCreator::create(const TQString &path, int /*width*/, int /*height*/, TQImage &image)
{
	// Create the temporar folder:
	KTempDir tempDir;
	tempDir.setAutoDelete(true);
	TQString tempFolder = tempDir.name();
	TQDir dir;
	dir.mkdir(tempFolder);
	const TQ_ULONG BUFFER_SIZE = 1024;

	TQFile file(path);
	if (file.open(IO_ReadOnly)) {
		TQTextStream stream(&file);
		stream.setEncoding(TQTextStream::Latin1);
		TQString line = stream.readLine();
		if (line != "BasKetNP:archive" && line != "BasKetNP:template") {
			file.close();
			return false;
		}
		while (!stream.atEnd()) {
			// Get Key/Value Pair From the Line to Read:
			line = stream.readLine();
			int index = line.find(':');
			TQString key;
			TQString value;
			if (index >= 0) {
				key = line.left(index);
				value = line.right(line.length() - index - 1);
			} else {
				key = line;
				value = "";
			}
			if (key == "preview*") {
				bool ok;
				ulong size = value.toULong(&ok);
				if (!ok) {
					file.close();
					return false;
				}
				// Get the preview file:
				TQFile previewFile(tempFolder + "preview.png");
				if (previewFile.open(IO_WriteOnly)) {
					char *buffer = new char[BUFFER_SIZE];
					TQ_LONG sizeRead;
					while ((sizeRead = file.readBlock(buffer, TQMIN(BUFFER_SIZE, size))) > 0) {
						previewFile.writeBlock(buffer, sizeRead);
						size -= sizeRead;
					}
					previewFile.close();
					delete buffer;
					image = TQImage(tempFolder + "preview.png");
					file.close();
					return true;
				}
			} else if (key.endsWith("*")) {
				// We do not know what it is, but we should read the embedded-file in order to discard it:
				bool ok;
				ulong size = value.toULong(&ok);
				if (!ok) {
					file.close();
					return false;
				}
				// Get the archive file:
				char *buffer = new char[BUFFER_SIZE];
				TQ_LONG sizeRead;
				while ((sizeRead = file.readBlock(buffer, TQMIN(BUFFER_SIZE, size))) > 0) {
					size -= sizeRead;
				}
				delete buffer;
			}
		}
		file.close();
	}
	return false;
}

ThumbCreator::Flags BasketThumbCreator::flags() const
{
	return (Flags) (DrawFrame | BlendIcon);
}

extern "C"
{
	ThumbCreator *new_creator()
	{
		return new BasketThumbCreator();
	}
};
