/***************************************************************************
*   Copyright (C) 2003-2005 by                                            *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   Copyright (C) 2006 Jason Kivlighn (jkivlighn@gmail.com)               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef INGREDIENTINPUTWIDGET_H
#define INGREDIENTINPUTWIDGET_H

#include <tqvbox.h>

#include "datablocks/unit.h"

class TQVBox;
class TQHBox;
class TQLabel;
class TQButtonGroup;
class TQWidgetStack;
class TQGroupBox;
class TQRadioButton;
class TQCheckBox;

class KComboBox;

class IngredientComboBox;
class HeaderComboBox;
class PrepMethodComboBox;
class RecipeDB;
class FractionInput;
class Ingredient;
class Element;
class ElementList;
class IngredientInput;

class IngredientInputWidget : public TQVBox
{
TQ_OBJECT

public:
	IngredientInputWidget( RecipeDB *db, TQWidget *parent );
	~IngredientInputWidget();

	void clear();

	static int createNewIngredientIfNecessary( const TQString &ing, RecipeDB *db );
	static int createNewUnitIfNecessary( const TQString &unit, bool plural, int ingredient_id, Unit &new_unit, RecipeDB *db );
	static TQValueList<int> createNewPrepIfNecessary( const ElementList &prepMethods, RecipeDB *db );
	static int createNewGroupIfNecessary( const TQString &group, RecipeDB *db );

signals:
	void ingredientEntered( const Ingredient &ing );

	void headerEntered( const Element &header );

public slots:
	void addIngredient();

private slots:
	void updateInputs(bool,IngredientInput*);

private:
	/** Reloads lists of units, ingredients, and preparation methods */
	void reloadCombos();

	void checkIfNewUnits();

	RecipeDB *database;

	TQValueList<IngredientInput*> m_ingInputs;
};

class IngredientInput : public TQHBox
{
TQ_OBJECT

public:
	IngredientInput( RecipeDB *db, TQWidget *parent, bool allowHeader = true );
	~IngredientInput();

	void clear();
	bool isInputValid();

	bool isHeader() const;
	Ingredient ingredient() const;
	TQString header() const;

	void reloadCombos();
	void enableHeader( bool );
	void updateTabOrder();

signals:
	void addIngredient();
	void orToggled(bool,IngredientInput*);

private slots:
	void loadUnitListCombo();
	void signalIngredient();
	void typeButtonClicked( int );
	void slotIngredientBoxLostFocus();
	void slotUnitBoxLostFocus();
	void slotPrepMethodBoxLostFocus();
	void orToggled(bool);

private:
	bool checkBounds();
	bool checkAmountEdit();

	RecipeDB *database;
	UnitList *unitComboList;

	TQCheckBox *orButton;
	TQGroupBox *ingredientGBox;
	TQLabel *amountLabel;
	FractionInput* amountEdit;
	TQLabel *unitLabel;
	KComboBox* unitBox;
	TQLabel *prepMethodLabel;
	PrepMethodComboBox* prepMethodBox;
	TQLabel *ingredientLabel;
	IngredientComboBox* ingredientBox;
	HeaderComboBox* headerBox;
	TQWidgetStack *header_ing_stack;
	TQButtonGroup *typeButtonGrp;
};

#endif //INGREDIENTINPUTWIDGET_H
