/***************************************************************************
                          checkbox.cpp - Checkbox widget 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqcheckbox.h>
#include <tqbutton.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "checkbox.h"

CheckBox::CheckBox(TQWidget *a_parent, const char *a_name)
  : TQCheckBox(a_parent, a_name), KommanderWidget(this)
{
  TQStringList states;
  states << "unchecked";
  states << "semichecked";
  states << "checked";
  setStates(states);
  TQStringList displayStates;
  displayStates << "checked";
  displayStates << "semichecked";
  displayStates << "unchecked";
  setDisplayStates(displayStates);
}

CheckBox::~CheckBox()
{
}

TQString CheckBox::currentState() const
{
  if (state() == TQButton::Off)
    return "unchecked";
  else if (state() == TQButton::NoChange)
    return "semichecked";
  else if (state() == TQButton::On)
    return "checked";
  return TQString();
}

bool CheckBox::isKommanderWidget() const
{
  return true;
}

TQStringList CheckBox::associatedText() const 
{
  return KommanderWidget::associatedText();
}

void CheckBox::setAssociatedText(const TQStringList & a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void CheckBox::setPopulationText(const TQString & a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString CheckBox::populationText() const
{
  return KommanderWidget::populationText();
}

void CheckBox::populate()
{
  setWidgetText(KommanderWidget::evalAssociatedText(populationText()));
}

void CheckBox::setWidgetText(const TQString& a_text)
{
  setText(a_text);
  emit widgetTextChanged(a_text);
}

void CheckBox::showEvent(TQShowEvent* e)
{
  TQCheckBox::showEvent(e);
  emit widgetOpened();
}

bool CheckBox::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::checked || f == DCOP::setChecked || f == DCOP::geometry || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor;
}

void CheckBox::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

TQString CheckBox::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return text();
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::checked:
      return TQString::number(isChecked());
    case DCOP::setChecked:
      setChecked(args[0] != "false" && args[0] != "0");
      break;
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}


#include "checkbox.moc"
