/***************************************************************************
    copyright            : (C) 2002-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "tabcontrol.h"

#include <tqtabbar.h>
#include <tqobjectlist.h>

using Tellico::GUI::TabControl;

TabControl::TabControl(TQWidget* parent_, const char* name_/*=0*/)
    : TQTabWidget(parent_, name_) {
}

TQTabBar* TabControl::tabBar() const {
  return TQTabWidget::tabBar();
}

void TabControl::setFocusToFirstChild() {
  TQWidget* page = currentPage();
  Q_ASSERT(page);
  if(!page) {
    return;
  }
  TQObjectList* list = page->queryList("TQWidget");
  for(TQObjectListIt it(*list); it.current(); ++it) {
    TQWidget* w = static_cast<TQWidget*>(it.current());
    if(w->isFocusEnabled()) {
      w->setFocus();
      break;
    }
  }
  delete list;
}

// have to loop backwards since count() gets decremented on delete
void TabControl::clear() {
  for(int i = count(); i > 0; --i) {
    TQWidget* w = page(i-1);
    if(w) {
      removePage(w);
      delete w;
    }
  }
}

void TabControl::setTabBarHidden(bool hide_) {
  TQWidget* rightcorner = cornerWidget(TopRight);
  TQWidget* leftcorner = cornerWidget(TopLeft);

  if(hide_) {
    if(leftcorner) {
      leftcorner->hide();
    }
    if(rightcorner) {
      rightcorner->hide();
    }
    tabBar()->hide();
  } else {
    tabBar()->show();
    if(leftcorner) {
      leftcorner->show();
    }
    if(rightcorner) {
      rightcorner->show();
    }
  }
}

#include "tabcontrol.moc"
