/***************************************************************************
                          uploadtreefolder.h  -  description
                             -------------------
    begin                : Sun Aug 25 2002
    copyright            : (C) 2002 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef UPLOADTREEFOLDER_H
#define UPLOADTREEFOLDER_H

#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqstring.h>
#include <tqstringlist.h>

#include <tdelistview.h>
#include <kurl.h>

/**
  *@author Andras Mantia
  */

class KURL;

class UploadTreeFolder : public TDEListViewItem  {
public:
  UploadTreeFolder( const KURL &a_url, TQListView * parent, const char * name);
  UploadTreeFolder( const KURL &a_url, UploadTreeFolder * parent, const char * name );
  virtual ~UploadTreeFolder();

  /** used for sorting */
  virtual TQString key ( int column, bool ascending ) const;
  TQString fullName();
  KURL url() {return m_url;}

  virtual void setOpen( bool );
  void setup();
  void setWhichPixmap(const TQString& pixmap );

public:
  UploadTreeFolder * parentFolder;
  KURL m_url;

public slots: // Public slots
  void reloadList();

};

#endif
