#!/usr/bin/env kjscmd

//
// Setup main window
//
var mw = new TDEMainWindow();

var view = new TQTextEdit( mw, 'view' );
view.text = '<h1>Hello World</h1>'
	  + '<p>This application is written entirely in Javascript and works '
	  + 'thanks to KJSEmbed</p>';

mw.setCentralWidget( view );

//
// Actions
//
var ac = mw.actionCollection();

//
// Create the quit action and connect it to a C++ slot
//
StdAction.quit( application, 'quit()', ac );

//
// We'll wire the file open action up to a JS function
//

mw.openFile = function() {
   var filename = StdDialog.getOpenFileName( '.', '*' );
   if ( filename.length > 0 ) {
      view.text = System.readFile( filename );
   }
}

var open_action = StdAction.open( null, '', ac );
open_action.connect( open_action, 'activated()', mw, 'openFile' );

//
// We'll just accept the default for the rest of the actions
//

StdAction.aboutApp( null, '', ac );
StdAction.aboutKDE( null, '', ac );
StdAction.actualSize( null, '', ac );
StdAction.addBookmark( null, '', ac );
StdAction.back( null, '', ac );
StdAction.close( null, '', ac );
StdAction.configureNotifications( null, '', ac );
StdAction.configureToolbars( null, '', ac );
StdAction.copy( null, '', ac );
StdAction.cut( null, '', ac );
StdAction.deselect( null, '', ac );
StdAction.editBookmarks( null, '', ac );
StdAction.fileNew( null, '', ac );
StdAction.find( null, '', ac );
StdAction.findNext( null, '', ac );
StdAction.findPrev( null, '', ac );
StdAction.fitToHeight( null, '', ac );
StdAction.fitToPage( null, '', ac );
StdAction.fitToWidth( null, '', ac );
StdAction.forward( null, '', ac );
StdAction.help( null, '', ac );
StdAction.helpContents( null, '', ac );
StdAction.home( null, '', ac );
StdAction.keyBindings( null, '', ac );
StdAction.mail( null, '', ac );
StdAction.openRecent( null, '', ac );
StdAction.paste( null, '', ac );
StdAction.preferences( null, '', ac );
StdAction.print( null, '', ac );
StdAction.printPreview( null, '', ac );
StdAction.redisplay( null, '', ac );
StdAction.redo( null, '', ac );
StdAction.replace( null, '', ac );
StdAction.reportBug( null, '', ac );
StdAction.revert( null, '', ac );
StdAction.save( null, '', ac );
StdAction.saveAs( null, '', ac );
StdAction.saveOptions( null, '', ac );
StdAction.selectAll( null, '', ac );
StdAction.showMenubar( null, '', ac );
StdAction.showStatusbar( null, '', ac );
StdAction.showToolbar( null, '', ac );
StdAction.spelling( null, '', ac );
StdAction.tipofDay( null, '', ac );
StdAction.undo( null, '', ac );
StdAction.up( null, '', ac );
StdAction.whatsThis( null, '', ac );
StdAction.zoom( null, '', ac );
StdAction.zoomIn( null, '', ac );
StdAction.zoomOut( null, '', ac );

//
// There are two different Go menus define in XMLGUI, and we're using
// the browser oriented one, so we don't use these actions.
//

//StdAction.firstPage( null, '', ac );
//StdAction.goGoto( null, '', ac );
//StdAction.gotoLine( null, '', ac );
//StdAction.gotoPage( null, '', ac );
//StdAction.lastPage( null, '', ac );
//StdAction.next( null, '', ac );
//StdAction.prior( null, '', ac );

//
// Activate XMLGUI and show the window
//
mw.createGUI( 'stdactionsui.rc' );
mw.resize( 500, 350 );
mw.show();
application.exec();
