/*
 * showtextdlg.cpp - dialog for displaying a text file
 * Copyright (C) 2003  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "showtextdlg.h"

#include <tqlayout.h>
#include <tqtextedit.h>
#include <tqpushbutton.h>
#include <tqfile.h>
#include <tqtextstream.h>


ShowTextDlg::ShowTextDlg(const TQString &fname, bool rich, TQWidget *parent, const char *name)
:TQDialog(parent, name, false, WDestructiveClose)
{
	TQString text;

	TQFile f(fname);
	if(f.open(IO_ReadOnly)) {
		TQTextStream t(&f);
		while(!t.eof())
			text += t.readLine() + '\n';
		f.close();
	}

	TQVBoxLayout *vb1 = new TQVBoxLayout(this, 8);
	TQTextEdit *te = new TQTextEdit(this);
	te->setReadOnly(true);
	te->setTextFormat(rich ? TQTextEdit::RichText : TQTextEdit::PlainText);
	te->setText(text);

	vb1->addWidget(te);

	TQHBoxLayout *hb1 = new TQHBoxLayout(vb1);
	hb1->addStretch(1);
	TQPushButton *pb = new TQPushButton(tr("&OK"), this);
	connect(pb, TQ_SIGNAL(clicked()), TQ_SLOT(accept()));
	hb1->addWidget(pb);
	hb1->addStretch(1);

	resize(560, 384);
}

#include "showtextdlg.moc"
